package com.testor.common.constant;

public enum EvaluateEnum {
   A(1,"预案适用性"),
   B(2,"预案充分性"),
   C(3,"人员响应状况"),
   D(4,"职责明确程度"),
   E(5,"物资到位状况"),
    ;
    private Integer code;

    private String msg;

    EvaluateEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static EvaluateEnum getEvaluateEnumByCode(Integer code) {
        EvaluateEnum[] values = values();
        for (EvaluateEnum value : values) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }
    public static EvaluateEnum getEvaluateEnumByMsg(String msg) {
        EvaluateEnum[] values = values();
        for (EvaluateEnum value : values) {
            if (value.getMsg().equals(msg)) {
                return value;
            }
        }
        return null;
    }
}
