package com.testor.ddd.safetyControl.infrastructure.repository.lecls.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;

/**
 * 现实风险等级与管控状态、管控层级的关联关系对象 t_safe_risk_real_level_relation
 * 
 * @author testor-framework
 * @date 2022-07-28 10:55:38
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_risk_real_level_relation")
@ApiModel(value = "TSafeRiskRealLevelRelation对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeRiskRealLevelRelationDO extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  @TableId(value = "id",type = IdType.ASSIGN_UUID)
  private String id;
/**
 * 管控状态
 */
  @ApiModelProperty(value = "管控状态")
  @TableField("control_status")
  private String controlStatus;
/**
 * 管控层级
 */
  @ApiModelProperty(value = "管控层级" , example = "0")
  @TableField("control_level")
  private String controlLevel;
/**
 * 现实风险
 */
  @ApiModelProperty(value = "现实风险")
  @TableField("real_level")
  private String realLevel;

  public static final String ID ="id";
  public static final String CONTROL_STATUS ="control_status";
  public static final String CONTROL_LEVEL ="control_level";
  public static final String REAL_LEVEL ="real_level";


}
