package com.testor.ddd.safetyControl.infrastructure.repository.space.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.ddd.safetyControl.domain.space.entity.TSafeSpaceTypeRepo;
import com.testor.ddd.safetyControl.infrastructure.repository.space.dao.TSafeSpaceTypeDao;
import com.testor.ddd.safetyControl.infrastructure.repository.space.entity.TSafeSpaceTypeDO;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceTypeDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceTypeDTOParam;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;

/**
 * 空间场所类型Service业务层处理
 * 
 * @author testor-framework
 * @date 2022-07-02 11:02:04
 */
@Service
public class TSafeSpaceTypeServiceImpl extends SuperServiceImpl<TSafeSpaceTypeDao, TSafeSpaceTypeDO> implements TSafeSpaceTypeRepo
{
    @Autowired(required = false)
    private TSafeSpaceTypeDao tSafeSpaceTypeDao;

    @Override
    public List<TSafeSpaceTypeDTO> checkUniqueness(String id, String orgId, String name, String code) {
        LambdaQueryWrapper<TSafeSpaceTypeDO> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TSafeSpaceTypeDO::getOrgId, orgId)
                .eq(TSafeSpaceTypeDO::getStatus, BizConstants.STATUS_ENABLE)
                .and(wq -> wq
                        .eq(TSafeSpaceTypeDO::getName, name)
                        .or()
                        .eq(TSafeSpaceTypeDO::getCode,code));
        if(!StrUtil.isBlank(id)) {
            queryWrapper.ne(TSafeSpaceTypeDO::getId, id);
        }
        List<TSafeSpaceTypeDO> spaceTypeDOList = tSafeSpaceTypeDao.selectList(queryWrapper);
        List<TSafeSpaceTypeDTO> spaceTypeDTOList = BeanHelper.listToList(spaceTypeDOList, TSafeSpaceTypeDTO.class);
        return spaceTypeDTOList;
    }

    public int insert(TSafeSpaceTypeDTO spaceTypeDTO){
        TSafeSpaceTypeDO data = BeanHelper.beanToBean(spaceTypeDTO, TSafeSpaceTypeDO.class);
        return tSafeSpaceTypeDao.insert(data);
    }

    public int updateById(TSafeSpaceTypeDTO spaceTypeDTO){
        TSafeSpaceTypeDO data = BeanHelper.beanToBean(spaceTypeDTO, TSafeSpaceTypeDO.class);
        return tSafeSpaceTypeDao.updateById(data);
    }

    /**
     * 作业区域分页查询
     * @param param
     * @return
     */
    public BaseResponseList<TSafeSpaceTypeDTO> listPage(TSafeSpaceTypeDTOParam param){
        Long page=
                StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
        Long limit=
                StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
        Page<TSafeSpaceTypeDO> resultPage=new Page<>(page,limit);
        QueryWrapper<TSafeSpaceTypeDO> queryWrapper=this.createQuery(param);
        Page<TSafeSpaceTypeDO> resultList= page(resultPage,queryWrapper);

        BaseResponseList<TSafeSpaceTypeDTO> baseResponseList=new BaseResponseList<>();
        List<TSafeSpaceTypeDTO> spaceTypeDTOList = BeanHelper.listToList(resultList.getRecords(), TSafeSpaceTypeDTO.class);
        baseResponseList.setData(spaceTypeDTOList);
        baseResponseList.setTotal(resultList.getTotal());
        return baseResponseList;
    }

    public TSafeSpaceTypeDTO findById(String id){
        if(StrUtil.isBlank(id)) {
            return null;
        }
        TSafeSpaceTypeDO spaceTypeDo = tSafeSpaceTypeDao.selectById(id);
        TSafeSpaceTypeDTO spaceTypeDTO = BeanHelper.beanToBean(spaceTypeDo, TSafeSpaceTypeDTO.class);
        return spaceTypeDTO;
    }

    @Override
    public List<TSafeSpaceTypeDTO> myList() {
        QueryWrapper<TSafeSpaceTypeDO> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("status","0");
        List<TSafeSpaceTypeDO> list = list(queryWrapper);
        List<TSafeSpaceTypeDTO> tSafeSpaceTypeDTOS = BeanHelper.listToList(list, TSafeSpaceTypeDTO.class);
        return tSafeSpaceTypeDTOS;
    }

    @Override
    public List<TSafeSpaceTypeDO> getListByIds(List<String> spaceTypeIds) {
        QueryWrapper<TSafeSpaceTypeDO> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("status","0");
        queryWrapper.in("id",spaceTypeIds);
        List<TSafeSpaceTypeDO> list = this.list(queryWrapper);
        return list;
    }

    /* Private Methods */
    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TSafeSpaceTypeDO> createQuery(TSafeSpaceTypeDTOParam queryParam){
        QueryWrapper<TSafeSpaceTypeDO> queryWrapper=new QueryWrapper<>();
        if(StringHelper.isNotEmpty(queryParam.getOrgId())){
            queryWrapper.eq(TSafeSpaceTypeDO.ORG_ID,queryParam.getOrgId());
        }
        if(StringHelper.isNotEmpty(queryParam.getName())){
            queryWrapper.like(TSafeSpaceTypeDO.NAME,queryParam.getName());
        }
        if(StringHelper.isNotEmpty(queryParam.getCode())){
            queryWrapper.eq(TSafeSpaceTypeDO.CODE,queryParam.getCode());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TSafeSpaceTypeDO.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TSafeSpaceTypeDO.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
            if(StringHelper.isNotEmpty(queryParam.getOrderType())
                    &&BizConstants.ASC.equals(queryParam.getOrderType())){
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            }else{
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        }else{
            queryWrapper.orderByDesc(TSafeSpaceTypeDO.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
