package com.testor.ddd.safetyControl.interfaces.model.vo.riskPoint;

import com.testor.ddd.safetyControl.interfaces.model.vo.riskOwner.TSafeRiskOwnerVO;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;


/**
 * 危险点(风险分级)对象 t_safe_risk_point
 * 
 * @author testor-framework
 * @date 2022-07-11 10:00:14
 */
@Data
public class TSafeRiskPointVO extends SuperModel
{
  /**
   * id
   */
  @ApiModelProperty(value = "id")
  private String id;

  @ApiModelProperty(value = "组织结构完整路径(到部门)")
  private String orgAllPath;
  /**
   * 组织机构id
   */
  @ApiModelProperty(value = "组织机构id")
  private String orgId;

  @ApiModelProperty(value = "组织机构")
  private String orgName;

  @ApiModelProperty(value = "组织机构全路径名称")
  private String orgFullName;

  @ApiModelProperty(value = "区域公司id")
  private String regionOrgId;

  @ApiModelProperty(value = "区域公司名称")
  private String regionOrgName;

  /**
   * 部门id
   */
  @ApiModelProperty(value = "部门id")
  private String departmentId;

  @ApiModelProperty(value = "部门")
  private String departmentName;

  /**
   * 名称
   */
  @ApiModelProperty(value = "名称")
  private String name;
  /**
   * 编码
   */
  @ApiModelProperty(value = "编码")
  private String code;
  /**
   * 风险类型(关联字典表id)
   */
  @ApiModelProperty(value = "风险类型(关联字典表id)")
  private String typeId;

  @ApiModelProperty(value = "风险类型")
  private String typeName;

  /**
   * 危险源关联类型(1-设备；2-空间)
   */
  @ApiModelProperty(value = "危险源关联类型(1-设备；2-空间)" , example = "0")
  private Integer relationType;
  /**
   * 关联设备id
   */
  @ApiModelProperty(value = "关联设备id")
  private String relationEquipmentId;

  @ApiModelProperty(value = "关联设备名称")
  private String relationEquipmentName;

  /**
   * 关联空间id(作业区域)
   */
  @ApiModelProperty(value = "关联空间id(作业区域)")
  private String relationSpaceId;
  /**
   * 空间位置
   */
  @ApiModelProperty(value = "空间位置")
  private String spaceLocation;
  /**
   * 固有风险等级(关联字典表id)
   */
  @ApiModelProperty(value = "固有风险等级(关联字典表id)")
  private String inherentLevelId;

  @ApiModelProperty(value = "固有风险等级名称")
  private String inherentLevelName;

  /**
   * 现实风险等级(关联字典表id)
   */
  @ApiModelProperty(value = "现实风险等级(关联字典表id)")
  private String realLevelId;

  @ApiModelProperty(value = "现实风险等级名称")
  private String realLevelName;

  /**
   * 管控层级(关联字典表id)
   */
  @ApiModelProperty(value = "管控层级(关联字典表id)")
  private String controlLevelId;

  @ApiModelProperty(value = "管控层级")
  private String controlLevelName;

  @ApiModelProperty(value = "管控部门与责任人")
  private List<TSafeRiskOwnerVO> riskOwnerList;

  @ApiModelProperty(value = "关联空间层级ids")
  private String relationSpaceLevelIds;

  @ApiModelProperty(value = "关联设备层级ids")
  private String relationEquipmentLevelIds;

  @ApiModelProperty(value = "基层单位id")
  private String basicOrgId;

  @ApiModelProperty(value = "基层单位名称")
  private String basicOrgName;
}
