package com.testor.ddd.safetyControl.interfaces.model.vo.riskSource;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @title TSafeRiskSourceExportVO
 * @description <TODO description class purpose>
 * @Author: qiao
 * @version:1.0.0
 * @create：4/25/23 3:34 PM
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class TSafeRiskSourceExportVO {

    @ExcelIgnore
    private String id;

    /**
     * 关联空间id(作业区域)
     */
    @ApiModelProperty(value = "空间编号（列表编号使用此值）")
    @ExcelProperty(value = {"危险源信息统计表","危险源编号"}, index = 0)
    private String relationSpaceCode;

    @ApiModelProperty(value = "区域公司名称")
    @ExcelProperty(value = {"危险源信息统计表","业务单位名称"}, index = 1)
    private String regionOrgName;

    @ApiModelProperty(value = "组织机构")
    @ExcelProperty(value = {"危险源信息统计表","基层企业名称"}, index = 2)
    private String orgName;

    /**
     * 空间位置
     */
    @ApiModelProperty(value = "空间位置")
    @ExcelProperty(value = {"危险源信息统计表","主单元"}, index = 3)
    private String spaceTypeName;

    @ApiModelProperty(value = "空间位置")
    @ExcelProperty(value = {"危险源信息统计表","分单元"}, index = 4)
    private String spaceName;

    @ApiModelProperty(value = "空间位置")
    @ExcelProperty(value = {"危险源信息统计表","子单元"}, index = 5)
    private String spaceLocationZ;

    @ApiModelProperty(value = "风险点名称")
    @ExcelProperty(value = {"危险源信息统计表","风险点"}, index = 6)
    private String pointName;

    /**
     * 危险源类型(关联字典表id)
     */
    @ApiModelProperty(value = "危险源类型")
    @ExcelProperty(value = {"危险源信息统计表","危险源类别"}, index = 7)
    private String typeName;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    @ExcelProperty(value = {"危险源信息统计表","危险源描述"}, index = 8)
    private String name;

    @ApiModelProperty(value = "固有风险等级名称")
    @ExcelProperty(value = {"危险源信息统计表","危险源编号"}, index = 9)
    private String inherentLevelName;

    /**
     * 可能导致的后果
     */
    @ApiModelProperty(value = "可能导致的后果")
    @ExcelProperty(value = {"危险源信息统计表","可能导致的事故类型"}, index = 10)
    private String consequenceName;

    /**
     * 控制依据
     */
    @ApiModelProperty(value = "控制依据")
    @ExcelProperty(value = {"危险源信息统计表","控制依据"}, index = 11)
    private String controlBasis;
    /**
     * 管控措施
     */
    @ApiModelProperty(value = "管控措施")
    @ExcelProperty(value = {"危险源信息统计表","管控措施"}, index = 12)
    private String controlMeasures;

    /**
     * 改进措施
     */
    @ApiModelProperty(value = "改进措施")
    @ExcelProperty(value = {"危险源信息统计表","改进措施/方案"}, index = 13)
    private String improvementPlan;


//    @ApiModelProperty(value = "现实风险辨识方法  1-lec; 2-ls")
//    @ExcelProperty(value = {"危险源编号"}, index = 12)
//    private Integer identificationMethod;

    @ExcelProperty(value = {"危险源信息统计表","LEC","L"}, index = 14)
    private Float lecL;

    @ExcelProperty(value = {"危险源信息统计表","LEC","E"}, index = 15)
    private Float lecE;

    @ExcelProperty(value = {"危险源信息统计表","LEC","C"}, index = 16)
    private Float lecC;

    @ExcelProperty(value = {"危险源信息统计表","LS","L"}, index = 17)
    private Float lsL;

    @ExcelProperty(value = {"危险源信息统计表","LS","S"}, index = 18)
    private Float lsS;

    @ApiModelProperty(value = "危险等级名称")
    @ExcelProperty(value = {"危险源信息统计表","现实风险"}, index = 19)
    private String riskLevelName;

    @ApiModelProperty(value = "检查频次(关联字典表id)")
    @ExcelProperty(value = {"危险源信息统计表","风险监测/检查频次"}, index = 20)
    private String checkFrequencyName;

    @ApiModelProperty(value = "监督主体部门")
    @ExcelProperty(value = {"危险源信息统计表","管控责任主体"}, index = 21)
    private String userDepartmentName;


    @ApiModelProperty(value = "用户")
    @ExcelProperty(value = {"危险源信息统计表","管控责任主体"}, index = 22)
    private String userName;

    @ApiModelProperty(value = "管控责任主体部门")
    @ExcelProperty(value = {"危险源信息统计表","监督主体"}, index = 23)
    private String departmentName;


    @ApiModelProperty(value = "管控层级")
    @ExcelProperty(value = {"危险源信息统计表","管控层级"}, index = 24)
    private String controlLevelName;











}
