package com.testor.module.contractor.ledger.model.domain;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.common.annotation.Translation;
import com.testor.common.constant.TransConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.transaction.annotation.Transactional;


/**
 * 承包商管理人员台账对象 t_contractor_person
 * 
 * @author testor-framework
 * @date 2024-11-20 09:58:38
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_person")
@ApiModel(value = "TContractorPerson对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorPerson extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键ID
 */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
/**
 * 所属承包商ID
 */
  @ApiModelProperty(value = "所属承包商ID")

  @TableField("info_id")
  private String infoId;
/**
 * 姓名
 */
  @ApiModelProperty(value = "姓名")

  @TableField("name")
  private String name;
/**
 * 性别
 */
  @ApiModelProperty(value = "性别")

  @TableField("gender")
  private String gender;
/**
 * 在职状态 0 离职 1 在职
 */
  @ApiModelProperty(value = "在职状态 0 离职 1 在职")

  @TableField("job_status")
  private String jobStatus;


  @TableField(exist = false)
  @Translation(type = TransConstant.DICT_ID_TO_LABEL,mapper = "jobStatus")
  private String jobStatusName;
/**
 * 身份证号
 */
  @ApiModelProperty(value = "身份证号")

  @TableField("id_card_no")
  private String idCardNo;
/**
 * 年龄
 */
  @ApiModelProperty(value = "年龄" , example = "0")

  @TableField("age")
  private Long age;
/**
 * 入职时间
 */
  @ApiModelProperty(value = "入职时间")

  @TableField("hire_date")

  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date hireDate;
/**
 * 岗位性质id（数据字典id）
 */
  @ApiModelProperty(value = "岗位性质id（数据字典id）")

  @TableField("job_nature_id")
  private String jobNatureId;
/**
 * 岗位性质
 */
  @ApiModelProperty(value = "岗位性质")

  @TableField("job_nature")
  @Translation(type = TransConstant.DICT_ID_TO_LABEL,mapper = "jobNatureId")
  private String jobNature;
/**
 * 岗位名称id（数据字典id）
 */
  @ApiModelProperty(value = "岗位名称id（数据字典id）")

  @TableField("job_title_id")
  private String jobTitleId;
/**
 * 岗位名称
 */
  @ApiModelProperty(value = "岗位名称")

  @TableField("job_title")
  @Translation(type = TransConstant.DICT_ID_TO_LABEL,mapper = "jobTitleId")
  private String jobTitle;
/**
 * 联系电话
 */
  @ApiModelProperty(value = "联系电话")

  @TableField("tel")
  private String tel;
/**
 * 合同年限
 */
  @ApiModelProperty(value = "合同年限")

  @TableField("contract_term")
  @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
  private String contractTerm;
/**
 * 岗位是否涉及法定职业病 0 否 1 是
 */
  @ApiModelProperty(value = "岗位是否涉及法定职业病 0 否 1 是")

  @TableField("is_oc")
  private String isOc;

  @TableField(exist = false)
  @Translation(mapper = "isOc",other = "0=否,1=是")
  private String isOcName;
/**
 * 涉及法定职业病名称id（数据字典id）
 */
  @ApiModelProperty(value = "涉及法定职业病名称id（数据字典id）")

  @TableField("oc_disease_id")
  private String ocDiseaseId;
/**
 * 涉及法定职业病名称
 */
  @ApiModelProperty(value = "涉及法定职业病名称")

  @TableField("oc_disease")
  @Translation(type = TransConstant.DICT_ID_TO_LABEL,mapper = "ocDiseaseId")
  private String ocDisease;
/**
 * 入职前职业健康情况
 */
  @ApiModelProperty(value = "入职前职业健康情况")

  @TableField("health")
  private String health;
/**
 * 职业禁忌症
 */
  @ApiModelProperty(value = "职业禁忌症")

  @TableField("contraindication")
  private String contraindication;
/**
 * 合同期限
 */
  @ApiModelProperty(value = "保险期限")

  @TableField("insurance_period")

  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date insurancePeriod;
/**
 * 保险种类
 */
  @ApiModelProperty(value = "保险种类")

  @TableField("insurance_type")
  private String insuranceType;
/**
 * 人员照片，存文件id
 */
  @ApiModelProperty(value = "人员照片，存文件id")

  @TableField("photo")
  private String photo;
/**
 * 人员保险，存文件id
 */
  @ApiModelProperty(value = "人员保险，存文件id")

  @TableField("insurance")
  private String insurance;
/**
 * 体检报告，存文件id
 */
  @ApiModelProperty(value = "体检报告，存文件id")

  @TableField("health_report")
  private String healthReport;
/**
 * 用工合同
 */
  @ApiModelProperty(value = "用工合同")

  @TableField("employee_contract")
  private String employeeContract;
/**
 * 所属企业id
 */
  @ApiModelProperty(value = "所属企业id")

  @TableField("org_id")
  private String orgId;

  /**
   * 所属承包商名称
   */
  @ApiModelProperty(value = "所属承包商名称")
  @TableField(exist = false)
  private String infoDesignation;

  /**
   * 合同期限
   */
  @ApiModelProperty(value = "合同期限")
  @TableField("contract_period")
  private String contractPeriod;

  public static final String ID ="id";
  public static final String INFO_ID ="info_id";
  public static final String NAME ="name";
  public static final String GENDER ="gender";
  public static final String JOB_STATUS ="job_status";
  public static final String ID_CARD_NO ="id_card_no";
  public static final String AGE ="age";
  public static final String HIRE_DATE ="hire_date";
  public static final String JOB_NATURE_ID ="job_nature_id";
  public static final String JOB_NATURE ="job_nature";
  public static final String JOB_TITLE_ID ="job_title_id";
  public static final String JOB_TITLE ="job_title";
  public static final String TEL ="tel";
  public static final String CONTRACT_TERM ="contract_term";
  public static final String IS_OC ="is_oc";
  public static final String OC_DISEASE_ID ="oc_disease_id";
  public static final String OC_DISEASE ="oc_disease";
  public static final String HEALTH ="health";
  public static final String CONTRAINDICATION ="contraindication";
  public static final String INSURANCE_PERIOD ="insurance_period";
  public static final String INSURANCE_TYPE ="insurance_type";
  public static final String PHOTO ="photo";
  public static final String INSURANCE ="insurance";
  public static final String HEALTH_REPORT ="health_report";
  public static final String EMPLOYEE_CONTRACT ="employee_contract";
  public static final String ORG_ID ="org_id";


}
