package com.testor.module.contractor.ledger.model.template;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.baomidou.mybatisplus.annotation.TableField;
import com.testor.common.annotation.ExcelDictFormat;
import com.testor.common.annotation.ExcelSelected;
import com.testor.common.annotation.Translation;
import com.testor.common.constant.ExcelSelectConstant;
import com.testor.common.constant.TransConstant;
import com.testor.common.convert.ExcelDictConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 物料台账导入模板
 */
@Data
public class MaterialTemplate {
    /**
     * 物料名称
     */
    @ExcelProperty(value = "物料名称",index = 0)
    @NotBlank(message = "物料名称不能为空")
    @ColumnWidth(value = 20)
    private String name;
    /**
     * 类别id（数据字典id）
     */
    @ExcelProperty(value = "类别",converter = ExcelDictConvert.class,index = 1)
    @ExcelDictFormat(dictType = "contractor_material_type")
    @ExcelSelected(type = ExcelSelectConstant.DICT_DATA_BY_TYPE, param = "contractor_material_type")
    @NotBlank(message = "类别不能为空")
    @ColumnWidth(value = 20)
    private String typeId;

    /**
     * 危险性id（数据字典id）
     */
    @ExcelProperty(value = "危险性",converter = ExcelDictConvert.class,index = 2)
    @ExcelDictFormat(dictType = "contractor_material_risk")
    @ExcelSelected(type = ExcelSelectConstant.DICT_DATA_BY_TYPE, param = "contractor_material_risk")
    @NotBlank(message = "危险性不能为空")
    @ColumnWidth(value = 20)
    private String riskId;

    /**
     * 型号
     */
    @ExcelProperty(value = "型号",index = 3)
    @NotBlank(message = "型号不能为空")
    @ColumnWidth(value = 20)
    private String model;
    /**
     * 数量
     */
    @ExcelProperty(value = "数量",index = 4)
    @NotNull(message = "数量不能为空")
    @Min(value = 1,message = "数量不能小于1")
    @Max(value = 99999L,message = "数量不能大于99999")
    @ColumnWidth(value = 20)
    private Long num;
    /**
     * 用途
     */
    @ExcelProperty(value = "用途",index = 5)
    @NotBlank(message = "用途不能为空")
    @ColumnWidth(value = 20)
    private String purpose;

    @ExcelProperty(value = "备注",index = 6)
    @ColumnWidth(value = 20)
    private String remarks;
}
