package com.testor.module.contractor.manage.controller;

import java.util.ArrayList;
import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.testor.module.contractor.manage.model.domain.TContractorAllowPerson;
import com.testor.module.contractor.manage.model.vo.TContractorAllowToolsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.contractor.manage.model.domain.TContractorAllowTools;
import com.testor.module.contractor.manage.model.dto.TContractorAllowToolsParam;
import com.testor.module.contractor.manage.model.dto.TContractorAllowToolsDelParam;
import com.testor.module.contractor.manage.service.TContractorAllowToolsService;

/**
 * 准入信息-工器具台账关联Controller
 *
 * @author testor-framework
 * @date 2024-11-26 14:09:01
 */
@RestController
@RequestMapping("/tools/tools")
@Api(value = "TContractorAllowTools", tags = "准入信息-工器具台账关联")
@Slf4j
public class TContractorAllowToolsController extends SuperController
{
    @Autowired
    private TContractorAllowToolsService tContractorAllowToolsService;

    /* Generated Method*/
	@ApiOperation(value = "新增 准入信息-工器具台账关联", notes = "Add TContractorAllowTools")
	@PostMapping(value = "/add")
	public BaseResponse<TContractorAllowTools>addEntity(@RequestBody TContractorAllowToolsParam addRequest) {
		BaseResponse<TContractorAllowTools> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			tContractorAllowToolsService.remove(new LambdaQueryWrapper<TContractorAllowTools>().eq(TContractorAllowTools::getAllowId, addRequest.getAllowId()));
			List<String> ids = addRequest.getIds();
			for (String id : ids) {
				TContractorAllowTools data = BeanHelper.beanToBean(addRequest, TContractorAllowTools.class);
				data.setId(IdHelper.getId32bit());
				data.setToolsId(id);
				tContractorAllowToolsService.save(data);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 准入信息-工器具台账关联 ", notes = "Get TContractorAllowTools By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TContractorAllowTools> getById(String id){
		BaseResponse<TContractorAllowTools> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TContractorAllowTools data= tContractorAllowToolsService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 准入信息-工器具台账关联 ", notes = "Update TContractorAllowTools By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TContractorAllowTools updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorAllowTools data=BeanHelper.beanToBean(updateRequest, TContractorAllowTools.class);
			boolean result= tContractorAllowToolsService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 准入信息-工器具台账关联 ", notes = "delete TContractorAllowTools By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContractorAllowToolsDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorAllowTools data= new TContractorAllowTools();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tContractorAllowToolsService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除准入信息-工器具台账关联", notes = "delete TContractorAllowTools by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TContractorAllowToolsDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TContractorAllowTools> tContractorAllowToolsList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TContractorAllowTools data= new TContractorAllowTools();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tContractorAllowToolsList.add(data);
			}
			boolean result = tContractorAllowToolsService.updateBatchById(tContractorAllowToolsList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 准入信息-工器具台账关联 分页列表", notes = "List TContractorAllowTools with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TContractorAllowToolsVo>>listEntity(TContractorAllowToolsParam param){
		BaseResponse<BaseResponseList<TContractorAllowToolsVo>>baseResponse=new BaseResponse<>();
		Page<TContractorAllowToolsVo> resultList= tContractorAllowToolsService.listEntity(param);
		BaseResponseList<TContractorAllowToolsVo> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 准入信息-工器具台账关联 列表", notes = "List TContractorAllowTools all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TContractorAllowTools>>listAllEntity(TContractorAllowToolsParam param){
		BaseResponse<BaseResponseList<TContractorAllowTools>>baseResponse=new BaseResponse<>();
		List<TContractorAllowTools> resultList=tContractorAllowToolsService.listAllEntity(param);
		BaseResponseList<TContractorAllowTools> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TContractorAllowTools> createQuery(TContractorAllowToolsParam queryParam){
		QueryWrapper<TContractorAllowTools> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getAllowId())){
			queryWrapper.eq(TContractorAllowTools.ALLOW_ID,queryParam.getAllowId());
		}
		if(StringHelper.isNotEmpty(queryParam.getToolsId())){
			queryWrapper.eq(TContractorAllowTools.TOOLS_ID,queryParam.getToolsId());
		}
		if(StringHelper.isNotEmpty(queryParam.getBizId())){
			queryWrapper.eq(TContractorAllowTools.BIZ_ID,queryParam.getBizId());
		}
		if(StringHelper.isNotEmpty(queryParam.getContractorId())){
			queryWrapper.eq(TContractorAllowTools.CONTRACTOR_ID,queryParam.getContractorId());
		}
		if(StringHelper.isNotEmpty(queryParam.getProjId())){
			queryWrapper.eq(TContractorAllowTools.PROJ_ID,queryParam.getProjId());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TContractorAllowTools.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TContractorAllowTools.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(TContractorAllowTools.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
