package com.testor.module.contractor.manage.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.contractor.manage.model.domain.TContractorEvaluateIndex;
import com.testor.module.contractor.manage.model.dto.TContractorEvaluateIndexParam;
import com.testor.module.contractor.manage.model.dto.TContractorEvaluateIndexDelParam;
import com.testor.module.contractor.manage.service.TContractorEvaluateIndexService;

/**
 * 承包商考核评价指标模板Controller
 *
 * @author testor-framework
 * @date 2024-11-30 21:04:04
 */
@RestController
@RequestMapping("/contractorManage/evaluateIndex")
@Api(value = "TContractorEvaluateIndex", tags = "承包商考核评价指标模板")
@Slf4j
public class TContractorEvaluateIndexController extends SuperController
{
    @Autowired
    private TContractorEvaluateIndexService tContractorEvaluateIndexService;

    /* Generated Method*/
	@ApiOperation(value = "新增 承包商考核评价指标模板", notes = "Add TContractorEvaluateIndex")
	@PostMapping(value = "/add")
	public BaseResponse<TContractorEvaluateIndex>addEntity(@RequestBody TContractorEvaluateIndex addRequest) {
		BaseResponse<TContractorEvaluateIndex> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            TContractorEvaluateIndex data=BeanHelper.beanToBean(addRequest,  TContractorEvaluateIndex.class);
			data.setId(id);
			boolean result= tContractorEvaluateIndexService.save(data);
			if(result){
                TContractorEvaluateIndex newEntity = new TContractorEvaluateIndex();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商考核评价指标模板 ", notes = "Get TContractorEvaluateIndex By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TContractorEvaluateIndex> getById(String indexCode){
		BaseResponse<TContractorEvaluateIndex> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(indexCode)){
			// TODO 按需求添加业务异常判断
            TContractorEvaluateIndex data= tContractorEvaluateIndexService.getById(indexCode);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 承包商考核评价指标模板 ", notes = "Update TContractorEvaluateIndex By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TContractorEvaluateIndex updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorEvaluateIndex data=BeanHelper.beanToBean(updateRequest, TContractorEvaluateIndex.class);
			boolean result= tContractorEvaluateIndexService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 承包商考核评价指标模板 ", notes = "delete TContractorEvaluateIndex By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContractorEvaluateIndexDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorEvaluateIndex data= new TContractorEvaluateIndex();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tContractorEvaluateIndexService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除承包商考核评价指标模板", notes = "delete TContractorEvaluateIndex by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TContractorEvaluateIndexDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TContractorEvaluateIndex> tContractorEvaluateIndexList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TContractorEvaluateIndex data= new TContractorEvaluateIndex();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tContractorEvaluateIndexList.add(data);
			}
			boolean result = tContractorEvaluateIndexService.updateBatchById(tContractorEvaluateIndexList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商考核评价指标模板 分页列表", notes = "List TContractorEvaluateIndex with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TContractorEvaluateIndex>>listEntity(TContractorEvaluateIndexParam param){
		BaseResponse<BaseResponseList<TContractorEvaluateIndex>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<TContractorEvaluateIndex> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorEvaluateIndex> queryWrapper=this.createQuery(param);
		Page<TContractorEvaluateIndex> resultList= tContractorEvaluateIndexService.page(resultPage,queryWrapper);
		BaseResponseList<TContractorEvaluateIndex> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商考核评价指标模板 列表", notes = "List TContractorEvaluateIndex all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TContractorEvaluateIndex>>listAllEntity(TContractorEvaluateIndexParam param){
		BaseResponse<BaseResponseList<TContractorEvaluateIndex>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorEvaluateIndex> queryWrapper=this.createQuery(param);
		List<TContractorEvaluateIndex> resultList=tContractorEvaluateIndexService.list(queryWrapper);
		BaseResponseList<TContractorEvaluateIndex> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TContractorEvaluateIndex> createQuery(TContractorEvaluateIndexParam queryParam){
		QueryWrapper<TContractorEvaluateIndex> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getDimension())){
			queryWrapper.eq(TContractorEvaluateIndex.DIMENSION,queryParam.getDimension());
		}
		if(StringHelper.isNotEmpty(queryParam.getFirstLevel())){
			queryWrapper.eq(TContractorEvaluateIndex.FIRST_LEVEL,queryParam.getFirstLevel());
		}
		if(StringHelper.isNotEmpty(queryParam.getSecondLevel())){
			queryWrapper.eq(TContractorEvaluateIndex.SECOND_LEVEL,queryParam.getSecondLevel());
		}
		if(StringHelper.isNotEmpty(queryParam.getEvaluationTerms())){
			queryWrapper.eq(TContractorEvaluateIndex.EVALUATION_TERMS,queryParam.getEvaluationTerms());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getBasicScore())){
			queryWrapper.eq(TContractorEvaluateIndex.BASIC_SCORE,queryParam.getBasicScore());
		}
		if(StringHelper.isNotEmpty(queryParam.getScoreStandard())){
			queryWrapper.eq(TContractorEvaluateIndex.SCORE_STANDARD,queryParam.getScoreStandard());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getScoreDeduct())){
			queryWrapper.eq(TContractorEvaluateIndex.SCORE_DEDUCT,queryParam.getScoreDeduct());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TContractorEvaluateIndex.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TContractorEvaluateIndex.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByAsc(TContractorEvaluateIndex.INDEX_CODE);
		}
		return queryWrapper;
	}
}
