package com.testor.module.contractor.manage.model.domain;

import com.testor.common.annotation.Translation;
import com.testor.common.constant.TransConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 基本管理对象 t_contractor_basic_info
 * 
 * @author testor-framework
 * @date 2024-11-22 21:03:04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_basic_info")
@ApiModel(value = "TContractorBasicInfo对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorBasicInfo extends SuperModel
{
    private static final long serialVersionUID = 1L;

  @TableId("id")
  private String id;

  /**
   * 所属企业
   */
  @ApiModelProperty(value = "承包商id")
  @TableField("contractor_id")
  private String contractorId;

  /**
   * 所属企业
   */
  @ApiModelProperty(value = "所属企业")
  @TableField("org_id")
  private String orgId;

/**
 * 流程实例ID
 */
  @ApiModelProperty(value = "流程实例ID")

  @TableField("process_id")
  private String processId;
/**
 * 流程状态
 */
  @ApiModelProperty(value = "流程状态")

  @TableField("process_status")
  private String processStatus;

  /**
   * 流程状态说明
   */
  @ApiModelProperty(value = "流程状态说明")

  @TableField(exist = false)
  @Translation(type = TransConstant.DICT_TYPE_TO_LABEL,mapper = "processStatus", other = "contractor_process_status")
  private String processStatusText;

  public static final String ID ="id";
  public static final String PROCESS_ID ="process_id";
  public static final String PROCESS_STATUS ="process_status";


}
