package com.testor.module.contractor.manage.model.domain;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 承包商管理-条件审查-审查内容对象 t_contractor_condition_review_detail
 * 
 * @author testor-framework
 * @date 2024-11-26 10:33:15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_condition_review_detail")
@ApiModel(value = "TContractorConditionReviewDetail对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorConditionReviewDetail extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键id
 */
  @ApiModelProperty(value = "主键id")

  @TableId("id")
  private String id;
/**
 * 条件审查id
 */
  @ApiModelProperty(value = "条件审查id")

  @TableField("review_id")
  private String reviewId;
/**
 * 审查内容
 */
  @ApiModelProperty(value = "审查内容")

  @TableField("content")
  private String content;
/**
 * 其他内容
 */
  @ApiModelProperty(value = "其他内容")

  @TableField("other_content")
  private String otherContent;
/**
 * 审查项编号
 */
  @ApiModelProperty(value = "审查项编号")

  @TableField("code")
  private String code;
/**
 * 审查状态：0不通过 1通过
 */
  @ApiModelProperty(value = "审查状态：0不通过 1通过")

  @TableField("review_status")
  private String reviewStatus;
/**
 * 是否符合要求
 */
  @ApiModelProperty(value = "是否符合要求")

  @TableField("is_compliant")
  private String isCompliant;

  @ApiModelProperty("排序")
  @TableField("tree_sort")
  private BigDecimal treeSort;

  @ApiModelProperty("附件")
  @TableField("attachment")
  private String attachment;

  public static final String ID ="id";
  public static final String REVIEW_ID ="review_id";
  public static final String CONTENT ="content";
  public static final String OTHER_CONTENT ="other_content";
  public static final String CODE ="code";
  public static final String REVIEW_STATUS ="review_status";
  public static final String IS_COMPLIANT ="is_compliant";
  public static final String TREE_SORT ="tree_sort";
  public static final String ATTACHMENT ="attachment";

}
