package com.testor.module.contractor.manage.model.domain;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.common.annotation.Translation;
import com.testor.common.constant.TransConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 日常管理-每日工作计划-检查任务对象 t_contractor_daily_plan_inspect
 * 
 * @author testor-framework
 * @date 2024-11-30 15:43:16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_daily_plan_inspect")
@ApiModel(value = "TContractorDailyPlanInspect对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorDailyPlanInspect extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键id
 */
  @ApiModelProperty(value = "主键id")

  @TableId("id")
  private String id;
/**
 * 日常工作计划id
 */
  @ApiModelProperty(value = "日常工作计划id")

  @TableField("plan_id")
  private String planId;
/**
 * 检查类型id（数据字典id）
 */
  @ApiModelProperty(value = "检查类型id（数据字典id）")

  @TableField("inspect_type_id")
  private String inspectTypeId;
/**
 * 检查类型
 */
  @ApiModelProperty(value = "检查类型")

  @TableField("inspect_type")
  @Translation(type = TransConstant.DICT_ID_TO_LABEL,mapper = "inspectTypeId")
  private String inspectType;
/**
 * 检查人
 */
  @ApiModelProperty(value = "检查人")

  @TableField("inspector")
  private String inspector;
/**
 * 检查时间
 */
  @ApiModelProperty(value = "检查时间")

  @TableField("inspect_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date inspectTime;

  @TableField(exist = false)
  private List<String> hazardIds;

  public static final String ID ="id";
  public static final String PLAN_ID ="plan_id";
  public static final String INSPECT_TYPE_ID ="inspect_type_id";
  public static final String INSPECT_TYPE ="inspect_type";
  public static final String INSPECTOR ="inspector";
  public static final String INSPECT_TIME ="inspect_time";


}
