package com.testor.module.hazard.model.dto;

import lombok.Data;

import java.util.Map;

@Data
public class HazardWorkPlanStatisticsResult {

    private String regionName;           // 大区
    private String businessDeptName;     // 经营部
    private String currentOrgName;       // 企业名称

    // 基础数量统计
    private Integer workCount;           // 危险作业总量
    private Integer ownCount;            // 自有员工作业数量
    private Integer stakeholderCount;    // 相关方作业数量

    // 分类统计
    private Map<String, Integer> workTypeStats;     // 作业类别统计 <类别名称, 数量>
    private Map<String, Integer> workLevelStats;    // 作业级别统计 <级别名称, 数量>
    private Map<String, Integer> workStatusStats;   // 作业状态统计 <状态名称, 数量>

}
