package com.testor.module.hazard.model.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.common.util.excel.LocalDateTimeConverter;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author rsq
 * @program zlmy_boot
 * @return
 **/
@Data
@AllArgsConstructor
@NoArgsConstructor
public class HazardWorkPlanCheckVO {

    @ExcelProperty(value = "序号", index = 0)
    private Integer number;

    @ExcelProperty(value = "作业编号", index = 1)
    private String code;

    @ExcelProperty(value = "基层单位", index = 2)
    private String basicUnit;

    @ExcelProperty(value = "检查单位", index = 3)
    private String checkUnit;

    @ExcelProperty(value = "作业类型", index = 4)
    private String workType;

    @ExcelProperty(value = "作业级别", index = 5)
    private String workLevel;

    @ExcelProperty(value = "相关方作业", index = 6)
    private String stakeholderWork;

    @ExcelProperty(value = "是否合规", index = 7)
    private String isCompliant;

    @ExcelProperty(value = "问题类别", index = 8)
    private String problemType;

    @ExcelProperty(value = "检查描述", index = 9)
    private String checkDescription;

    @ExcelProperty(value = "检查人", index = 10)
    private String checkName;

    @ExcelProperty(value = "检查时间", index = 11)
    private Date checkTime;


}
