package com.testor.module.hire.job;

import com.testor.module.hire.entity.DepositoryAccessInfo;
import com.testor.module.hire.service.DepositoryAccessInfoService;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * @author caq
 * @date 2024/9/2
 * @description TODO
 */
@Component
public class HireDepositoryJob {

    @Autowired
    private DepositoryAccessInfoService depositoryAccessInfoService;


    @XxlJob("updateHireDepositoryState")
    public void updateHireDepositoryState() {

        List<DepositoryAccessInfo> list = depositoryAccessInfoService.lambdaQuery().eq(DepositoryAccessInfo::getStatus, "1").list();
        for (DepositoryAccessInfo depositoryAccessInfo : list) {
            // 更新仓库状态
            Date accessHireStartTime = depositoryAccessInfo.getAccessHireStartTime();
            Date accessHireEndTime = depositoryAccessInfo.getAccessHireEndTime();

            Date now = new Date();

            if (accessHireStartTime.compareTo(now)<=0 && accessHireEndTime.compareTo(now)>0) {
                depositoryAccessInfo.setStatus("0");
            }else {
                depositoryAccessInfo.setStatus("2");
            }
            depositoryAccessInfoService.updateById(depositoryAccessInfo);
        }

    }
}
