package com.testor.module.safe.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.safe.model.domain.TSafeHazardOrg;
import com.testor.module.safe.model.dto.TSafeHazardOrgDTO;
import com.testor.module.safe.model.dto.TSafeHazardOrgParam;
import com.testor.module.safe.model.vo.HiddenDangerVO;
import com.testor.module.safe.model.vo.TSafeHazardExportVO;
import com.testor.module.safe.model.vo.TSafeHazardOrgStatisticsTypeVO;
import com.testor.module.safe.model.vo.TSafeHazardOrgStatisticsVO;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 隐患上报台账Mapper接口
 *
 * @author testor-framework
 * @date 2022-08-04 14:01:01
 */
public interface TSafeHazardOrgDao extends SuperDao<TSafeHazardOrg> {

    IPage<TSafeHazardOrgDTO> selectBaseList(Page<TSafeHazardOrgDTO> page, @Param("param") TSafeHazardOrgParam param);

    IPage<TSafeHazardExportVO> exportList(Page<TSafeHazardOrgDTO> page, @Param("param") TSafeHazardOrgParam param);

    /**
     * 隐患数量统计
     *
     * @param param .
     * @return .
     */
    List<TSafeHazardOrgStatisticsVO> hiddenDangerStatistics(@Param("param") TSafeHazardOrgParam param);

    /**
     * 根据功能配置-隐患排查治理-巡检排查标准管理中进行隐患数量统计-设备统计
     *
     * @param param
     * @return
     */
    List<TSafeHazardOrgStatisticsTypeVO> hiddenDangerStatisticsEquipmentType(@Param("param") TSafeHazardOrgParam param);

    /**
     * 根据功能配置-隐患排查治理-巡检排查标准管理中进行隐患数量统计-空间统计
     *
     * @param param
     * @return
     */
    List<TSafeHazardOrgStatisticsTypeVO> hiddenDangerStatisticsSpaceType(@Param("param") TSafeHazardOrgParam param);

    /**
     * 根据功能配置-隐患排查治理-巡检排查标准管理中进行隐患数量统计-自定义
     *
     * @param param
     * @return
     */
    List<TSafeHazardOrgStatisticsTypeVO> hiddenDangerStatisticsStandardType(@Param("param") TSafeHazardOrgParam param);
    /**
     * 根据隐患类型统计
     *
     * @param param
     * @return
     */
    List<TSafeHazardOrgStatisticsTypeVO> hiddenDangerStatisticsType(@Param("param") TSafeHazardOrgParam param);


    /**
     * 根据隐患位置统计
     *
     * @param param
     * @return
     */
    List<TSafeHazardOrgStatisticsTypeVO> hiddenDangerStatisticsLocation(@Param("param") TSafeHazardOrgParam param);


    /**
     * 根据隐患原因统计
     *
     * @param param
     * @return
     */
    List<TSafeHazardOrgStatisticsTypeVO> hiddenDangerStatisticsCause(@Param("param") TSafeHazardOrgParam param);


    /**
     * 根据隐患类型统计
     *
     * @param param
     * @return
     */
    List<TSafeHazardOrgStatisticsTypeVO> hiddenDangerStatisticsByType(@Param("param") TSafeHazardOrgParam param);


    /**
     * 根据隐患分类统计
     *
     * @param param
     * @return
     */
    List<TSafeHazardOrgStatisticsTypeVO> hiddenDangerStatisticsClassify(@Param("param") TSafeHazardOrgParam param);

    /**
     * 根据隐患发现形式统计
     *
     * @param param
     * @return
     */
    List<TSafeHazardOrgStatisticsTypeVO> hiddenDangerStatisticsByCheckType(@Param("param") TSafeHazardOrgParam param);

    /**
     * 根据隐患发现形式统计
     *
     * @param param
     * @return
     */
    List<TSafeHazardOrgStatisticsTypeVO> hiddenDangerStatisticsOrgType(@Param("param") TSafeHazardOrgParam param);


    /**
     * 隐患发现形式统计
     *
     * @param param
     * @return
     */
    List<TSafeHazardOrgStatisticsTypeVO> hiddenDangerStatisticsCheckType(@Param("param") TSafeHazardOrgParam param);
    List<TSafeHazardOrgStatisticsTypeVO> hiddenDangerStatisticsReason(@Param("param") TSafeHazardOrgParam param);

    List<HiddenDangerVO> getHiddenDangerNumber(@Param("orgIds") List<String> orgIds,@Param("treeLevel") int treeLevel);
    List<HiddenDangerVO> getHiddenDanger(@Param("orgIds") List<String> orgIds);

    int getHiddenDangerCount(String orgId);
}
