package com.testor.module.safe.model.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;


/**
 * 隐患上报台账对象 t_safe_hazard_org
 *
 * @author testor-framework
 * @date 2022-08-04 14:01:01
 */

@Data
@ApiModel(value = "TSafeHazardOrgDTO 对象", description = "")
public class TSafeHazardOrgDTO extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    private String id;

    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")
    private String processStatus;
    /**
     * 隐患单位（机构id0
     */
    @ApiModelProperty(value = "隐患单位（机构id")
    private String orgId;

    /**
     * 隐患单位（机构id0
     */
    @ApiModelProperty(value = "隐患单位名称")
    private String orgName;

    @ApiModelProperty("业务单位")
    private String businessOrgName;

    /**
     * 隐患名称
     */
    @ApiModelProperty(value = "隐患名称")
    private String name;
    /**
     * 发现形式
     */
    @ApiModelProperty(value = "发现形式")
    private String checkType;
    /**
     * 管理对象（1-设备设施/2-空间场所/-3管理内页）
     */
    @ApiModelProperty(value = "管理对象（1-设备设施/2-空间场所/-3管理内页）")
    private String manageObject;
    /**
     * 关联设备
     */
    @ApiModelProperty(value = "关联设备")
    private String equipment;
    /**
     * 隐患位置（当关联对象为 设备设施/空间场所 时有值）
     */
    @ApiModelProperty(value = "隐患位置（当关联对象为 设备设施/空间场所 时有值）")
    private String location;
    /**
     * 照片（6张）
     */
    @ApiModelProperty(value = "照片（6张）")
    private String images;
    /**
     * 是否转工单（0-否；1-是）
     */
    @ApiModelProperty(value = "是否转工单（0-否；1-是）")
    private String workOrder;
    /**
     * 隐患分类
     */
    @ApiModelProperty(value = "隐患分类")
    private String classify;
    /**
     * 隐患级别
     */
    @ApiModelProperty(value = "隐患级别")
    private String level;
    /**
     * 隐患类型
     */
    @ApiModelProperty(value = "隐患类型")
    private String type;
    /**
     * 法规依据
     */
    @ApiModelProperty(value = "法规依据")
    private String rule;
    /**
     * 整改前防范措施
     */
    @ApiModelProperty(value = "整改前防范措施")
    private String guardAgainst;
    /**
     * 整改人
     */
    @ApiModelProperty(value = "整改人")
    private String rectifyPeople;
    /**
     * 整改开始时间
     */
    @ApiModelProperty(value = "整改开始时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date rectifyStartDate;
    /**
     * 整改结束时间
     */
    @ApiModelProperty(value = "整改结束时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date rectifyEndDate;
    /**
     * 验收人
     */
    @ApiModelProperty(value = "验收人")
    private String acceptance;

    @ApiModelProperty(value = "备注")
    private String remarks;

    @ApiModelProperty(value = "编号")
    private String numbering;

    @ApiModelProperty(value = "整改结束时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date rectifyDate;

    @ApiModelProperty("检查人")
    private String createName;

    @ApiModelProperty("整改措施")
    private String rectification;

    @ApiModelProperty("隐患问题")
    private String hiddenDangerReason;

    @ApiModelProperty(value = "上报时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;

    @ApiModelProperty(value = "是否重复 0否 1是")
    private String isRepeat;

    @ApiModelProperty(value = "是否重复")
    private String isRepeatName;

    @ApiModelProperty(value = "计点分数")
    private String score;

    public void setIsRepeat(String isRepeat) {
        this.isRepeat = isRepeat;
        if (isRepeat.equals("0")) {
            this.isRepeatName = "否";
        }
        if (isRepeat.equals("1")) {
            this.isRepeatName = "是";
        }
    }
}
