package com.testor.module.safeCheck.model.domain;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 巡检人员对象 t_safe_hazard_check_people
 * 
 * @author testor-framework
 * @date 2022-08-04 11:07:50
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_hazard_check_people")
@ApiModel(value = "TSafeHazardCheckPeople对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeHazardCheckPeople extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  @TableId(value = "id",type = IdType.ASSIGN_UUID)
  private String id;
/**
 * 巡检计划id
 */
  @ApiModelProperty(value = "巡检计划id")

  @TableField("plan_id")
  private String planId;
/**
 * 巡检人员
 */
  @ApiModelProperty(value = "巡检人员")

  @TableField("user_id")
  private String userId;
/**
 * 巡检类型(关联字典表id)
 */
  @ApiModelProperty(value = "巡检类型(关联字典表id)")

  @TableField("check_type_id")
  private String checkTypeId;
/**
 * 任务频次key(关联字典表key)
 */
  @ApiModelProperty(value = "任务频次key(关联字典表key)")

  @TableField("frequency_key")
  private String frequencyKey;
/**
 * 时间
 */
  @ApiModelProperty(value = "时间")

  @TableField("start_time")
  private String startTime;
/**
 * 日期(日期,不包含时间)
 */
  @ApiModelProperty(value = "日期(日期,不包含时间)")

  @TableField("start_date")
  private String startDate;
/**
 * 数字天(如一个月的第几天，周的周几)
 */
  @ApiModelProperty(value = "数字天(如一个月的第几天(1-31,0表示最后一天)，周的周几(1-7))" , example = "0")
  @TableField("start_day_num")
  private Integer startDayNum;
/**
 * 数字月(如年的第几个月，季度的第几个月)
 */
  @ApiModelProperty(value = "数字月(如年的第几个月，季度的第几个月)" , example = "0")

  @TableField("start_month_num")
  private Integer startMonthNum;
/**
 * 时间
 */
  @ApiModelProperty(value = "时间")

  @TableField("end_time")
  private String endTime;
/**
 * 日期(日期,不包含时间)
 */
  @ApiModelProperty(value = "日期(日期,不包含时间)")

  @TableField("end_date")
  private String endDate;
/**
 * 数字天(如一个月的第几天，周的周几)
 */
  @ApiModelProperty(value = "数字天(如一个月的第几天，周的周几)" , example = "0")

  @TableField("end_day_num")
  private Integer endDayNum;
/**
 * 数字月(如年的第几个月，季度的第几个月)
 */
  @ApiModelProperty(value = "数字月(如年的第几个月，季度的第几个月)" , example = "0")

  @TableField("end_month_num")
  private Integer endMonthNum;
/**
 * cron
 */
  @ApiModelProperty(value = "开始时间cron")
  @TableField("start_cron_expression")
  private String startCronExpression;

  @ApiModelProperty(value = "结束时间cron")
  @TableField("end_cron_expression")
  private String endCronExpression;

  @ApiModelProperty(value = "是否生成任务(0-未生成，1-生成)")
  @TableField("generate_task")
  private String generateTask;

  @ApiModelProperty(value = "巡检人员层级id")
  @TableField("user_parent_ids")
  private String userParentIds;

  public static final String ID ="id";
  public static final String PLAN_ID ="plan_id";
  public static final String USER_ID ="user_id";
  public static final String CHECK_TYPE_ID ="check_type_id";
  public static final String FREQUENCY_KEY ="frequency_key";
  public static final String START_TIME ="start_time";
  public static final String START_DATE ="start_date";
  public static final String START_DAY_NUM ="start_day_num";
  public static final String START_MONTH_NUM ="start_month_num";
  public static final String END_TIME ="end_time";
  public static final String END_DATE ="end_date";
  public static final String END_DAY_NUM ="end_day_num";
  public static final String END_MONTH_NUM ="end_month_num";
  public static final String START_CRON_EXPRESSION ="start_cron_expression";
  public static final String END_CRON_EXPRESSION ="end_cron_expression";
  public static final String GENERATE_TASK ="generate_task";

}
