package com.testor.module.safeCheck.model.para;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.module.safeCheck.model.domain.TSafeCheckOrg;
import com.testor.module.safeCheck.model.domain.TSafeCheckPerson;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;


/**
 * 安全检查计划对象 t_safe_check_plan
 *
 * @author testor-framework
 * @date 2024-09-03 08:04:18
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "TSafeCheckPlan对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeCheckPlanPara extends SuperModel {
    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private String id;
    /**
     * 排查单位id
     */
    @ApiModelProperty(value = "排查单位id")
    private String orgId;

    @ApiModelProperty(value = "机构名称")
    private String orgName;
    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String name;
    /**
     * 计划开始时间
     */
    @ApiModelProperty(value = "计划开始时间")
    @TableField("start_date")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;

    /**
     * 计划结束时间
     */
    @ApiModelProperty(value = "计划结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;

    /**
     * 是否双休日(0-不包含，跳过；1-包含，不跳过)
     */
    @ApiModelProperty(value = "是否双休日(0-不包含，跳过；1-包含，不跳过)")
    private String inWeekend;
    /**
     * 是否跳过节假日(0-不包含，跳过；1-包含，不跳过)
     */
    @ApiModelProperty(value = "是否跳过节假日(0-不包含，跳过；1-包含，不跳过)")
    private String inHoliday;
    /**
     * 提前小时
     */
    @ApiModelProperty(value = "提前小时", example = "0")
    private Long advanceHour;

    @ApiModelProperty(value = "检查人员")
    private List<TSafeCheckPerson> tSafeCheckPersonList;

    @TableField(exist = false)
    @ApiModelProperty(value = "被检查机构")
    private List<TSafeCheckOrg> tSafeCheckOrgs;

    @TableField(exist = false)
    @ApiModelProperty(value = "计划状态 0未开始 1进行中 2已结束")
    private String planStatus;

    @TableField(exist = false)
    @ApiModelProperty(value = "计划状态")
    private String planStatusName;

    @TableField(exist = false)
    @ApiModelProperty(value = "检查类型")
    private String checkType;

    public static final String ID = "id";
    public static final String ORG_ID = "org_id";
    public static final String NAME = "name";
    public static final String START_DATE = "start_date";
    public static final String END_DATE = "end_date";
    public static final String IN_WEEKEND = "in_weekend";
    public static final String IN_HOLIDAY = "in_holiday";
    public static final String ADVANCE_HOUR = "advance_hour";

    public enum PlanStatus {
        NOT_STARTED("0", "未开始"),
        IN_PROGRESS("1", "进行中"),
        COMPLETED("2", "已结束");

        private final String code;
        private final String name;

        PlanStatus(String code, String name) {
            this.code = code;
            this.name = name;
        }

        public String getCode() {
            return code;
        }

        public String getName() {
            return name;
        }

        public static PlanStatus fromCode(String code) {
            for (PlanStatus status : PlanStatus.values()) {
                if (status.code.equals(code)) {
                    return status;
                }
            }
            throw new IllegalArgumentException("Unknown code: " + code);
        }
    }


}
