package com.testor.module.safeCheck.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.testor.biz.sys.user.model.domain.SysUser;
import com.testor.biz.sys.user.service.SysUserService;
import com.testor.common.constant.StatusEnum;
import com.testor.module.safeCheck.dao.TSafeCheckTaskPostponeDao;
import com.testor.module.safeCheck.model.domain.TSafeCheckTaskPostpone;
import com.testor.module.safeCheck.service.TSafeCheckTaskPostponeService;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 安全检查任务延期记录Service业务层处理
 * 
 * @author testor-framework
 * @date 2024-09-05 12:16:55
 */
@Service
public class TSafeCheckTaskPostponeServiceImpl extends SuperServiceImpl<TSafeCheckTaskPostponeDao, TSafeCheckTaskPostpone> implements TSafeCheckTaskPostponeService
{
    @Autowired(required = false)
    private TSafeCheckTaskPostponeDao tSafeCheckTaskPostponeDao;

    @Autowired
    private SysUserService sysUserService;

    @Override
    public List<TSafeCheckTaskPostpone> findByTaskId(String taskId) {
        List<TSafeCheckTaskPostpone> list = this.list(new LambdaQueryWrapper<TSafeCheckTaskPostpone>().eq(TSafeCheckTaskPostpone::getTaskId, taskId)
                .eq(TSafeCheckTaskPostpone::getStatus, StatusEnum.USE.getCode()).orderByAsc(TSafeCheckTaskPostpone::getCreateDate));

        return list.stream().peek(tSafeCheckTaskPostpone -> {
            SysUser byId = sysUserService.getById(tSafeCheckTaskPostpone.getCreateBy());
            if (byId != null) {
                tSafeCheckTaskPostpone.setCreateByName(byId.getUserName());
            }
        }).collect(Collectors.toList());
    }
}
