package com.testor.module.train.myManagement.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 评分-安全教育培训对象 t_train_grade
 * 
 * @author testor-framework
 * @date 2022-11-17 15:26:58
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_train_grade")
@ApiModel(value = "TTrainGrade对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TTrainGrade extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键 id
 */
  @ApiModelProperty(value = "主键 id")

  @TableId("id")
  private String id;
/**
 * 机构名称
 */
  @ApiModelProperty(value = "机构名称")

  @TableField("org_name")
  private String orgName;
/**
 * 机构id
 */
  @ApiModelProperty(value = "机构id")

  @TableField("org_id")
  private String orgId;
/**
 * 任务id
 */
  @ApiModelProperty(value = "任务id")

  @TableField("task_id")
  private String taskId;
/**
 * 评分
 */
  @ApiModelProperty(value = "评分")

  @TableField("assess_minute")
  private Integer assessMinute;

  /**
 * 评分
 */
  @ApiModelProperty(value = "评分")

  @TableField("assess_minute_info")
  private String assessMinuteInfo;

  /**
   * 评分人
   */
  @ApiModelProperty(value = "评分人")

  @TableField("user_id")
  private String userId;

  public static final String ID ="id";
  public static final String ORG_NAME ="org_name";
  public static final String ORG_ID ="org_id";
  public static final String TASK_ID ="task_id";
  public static final String ASSESS_MINUTE ="assess_minute";
  public static final String ASSESS_MINUTE_INFO ="assess_minute_info";
  public static final String USER_ID = "user_id";


}
