/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.file.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.biz.file.FileEnumCode;
import com.testor.biz.file.model.domain.SysFile;
import com.testor.biz.file.model.domain.TSysFileBiz;
import com.testor.biz.file.model.dto.FileAjaxDTO;
import com.testor.biz.file.model.dto.FileDTO;
import com.testor.biz.file.model.dto.SysFileParam;
import com.testor.biz.file.model.dto.TSysFileBizParam;
import com.testor.biz.file.service.SysFileService;
import com.testor.biz.file.service.TSysFileBizService;
import com.testor.biz.helper.CommonHelper;
import com.testor.biz.sys.file.util.MinioUtilS;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import com.tongtech.tfw.backend.core.constants.IoConstants;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.codec.Base64Helper;
import com.tongtech.tfw.backend.core.helper.datetime.DatetimeHelper;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(value="SysFile", tags={"File \u4e0a\u4f20\u4e0b\u516c\u5171\u63a5\u53e3"})
@RequestMapping(value={"/file"})
public class SysFileController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(SysFileController.class);
    @Autowired
    private SysFileService sysFileService;
    @Autowired
    private TSysFileBizService tSysFileBizService;
    @Autowired
    private MinioClient minioClient;
    @Value(value="${minio.bucket}")
    private String bucketName;
    @Value(value="${minio.endpoint}")
    private String address;
    @Autowired
    private MinioUtilS minioUtilS;
    @Value(value="${apisix.minioroute.url}")
    private String apisixUrl;
    @Value(value="${file.path}")
    private String fileRootPath;

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6", notes="\u4e0a\u4f20\u6587\u4ef6 Upload File")
    @PostMapping(value={"/upload"})
    public BaseResponse<FileDTO> upload(@RequestParam MultipartFile file) {
        BaseResponse baseResponse = new BaseResponse();
        if (file.isEmpty()) {
            throw new ApiException(FileEnumCode.NOT_FOUND.transform());
        }
        String fileName = file.getOriginalFilename();
        long size = file.getSize();
        int beginIndex = fileName.indexOf(".") + 1;
        String ext = StringHelper.substring((String)fileName, (int)beginIndex, (int)fileName.length());
        String filePath = DatetimeHelper.getDateTime8Length();
        String saveName = IdHelper.getId32bitTime();
        byte[] fileContent = new byte[]{};
        try {
            fileContent = file.getBytes();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!CommonHelper.checkFileType(fileContent, ext)) {
            throw new ApiException(FileEnumCode.TYPE_CHECK_FAILD.transform());
        }
        ByteArrayInputStream input = new ByteArrayInputStream(fileContent);
        String contentType = file.getContentType();
        this.uploadMinio(input, fileName, contentType);
        SuperModel sysFile = ((SysFile.SysFileBuilder)((SysFile.SysFileBuilder)((SysFile.SysFileBuilder)((Object)((SysFile.SysFileBuilder)((Object)((SysFile.SysFileBuilder)((Object)((SysFile.SysFileBuilder)((Object)SysFile.builder().fileId(saveName))).fileName(fileName))).fileSize(BigDecimal.valueOf(size)))).fileExt(ext))).filePath(this.apisixUrl + "/" + this.bucketName + "/" + fileName).createBy(this.getUserId())).updateBy(this.getUserId())).build();
        boolean result = this.sysFileService.save(sysFile);
        if (result) {
            FileDTO newEntity = FileDTO.builder().fileId(saveName).fileName(fileName).filePath(this.apisixUrl + "/" + this.bucketName + "/" + fileName).build();
            baseResponse.setData((Object)newEntity);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6BASE64", notes="\u4e0a\u4f20\u6587\u4ef6BASE64 Upload File Base 64")
    @PostMapping(value={"/uploadBase64"})
    public BaseResponse<FileDTO> uploadBase64(@RequestBody FileAjaxDTO fileAjaxDTO) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isEmpty((Object)fileAjaxDTO) || StringHelper.isEmpty((CharSequence)fileAjaxDTO.getFile()) || fileAjaxDTO.getFile().split(",").length < 2) {
            throw new ApiException(FileEnumCode.NOT_FOUND.transform());
        }
        String fileName = fileAjaxDTO.getFileName();
        long size = Long.parseLong(fileAjaxDTO.getFileSize());
        int beginIndex = fileName.indexOf(".") + 1;
        String ext = StringHelper.substring((String)fileName, (int)beginIndex, (int)fileName.length());
        String filePath = DatetimeHelper.getDateTime8Length();
        String saveName = IdHelper.getId32bitTime();
        byte[] fileContent = Base64Helper.decode((CharSequence)fileAjaxDTO.getFile().split(",")[1]);
        if (!CommonHelper.checkFileType(fileContent, ext)) {
            throw new ApiException(FileEnumCode.TYPE_CHECK_FAILD.transform());
        }
        ByteArrayInputStream input = new ByteArrayInputStream(fileContent);
        String contentType = MediaTypeFactory.getMediaType((String)fileName).orElse(MediaType.APPLICATION_OCTET_STREAM).toString();
        this.uploadMinio(input, fileName, contentType);
        log.info("\u4fdd\u5b58\u6210\u529f\uff1aFileId\uff1a" + saveName + ", ext: " + ext + ", path:" + filePath + ", name:" + fileName + ", user: " + this.getUserId());
        SuperModel sysFile = ((SysFile.SysFileBuilder)((SysFile.SysFileBuilder)((SysFile.SysFileBuilder)((Object)((SysFile.SysFileBuilder)((Object)((SysFile.SysFileBuilder)((Object)((SysFile.SysFileBuilder)((Object)SysFile.builder().fileId(saveName))).fileName(fileName))).fileSize(BigDecimal.valueOf(size)))).fileExt(ext))).filePath(filePath + IoConstants.PATH_SLASH + saveName).createBy(this.getUserId())).updateBy(this.getUserId())).build();
        boolean result = this.sysFileService.save(sysFile);
        if (result) {
            String Path2 = this.address + "/" + this.bucketName + "/" + fileName;
            FileDTO newEntity = FileDTO.builder().fileId(saveName).fileName(fileName).filePath(Path2).build();
            baseResponse.setData((Object)newEntity);
        }
        return baseResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadMinio(InputStream input, String fileName, String contentType) {
        try {
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.bucketName)).object(fileName)).stream(input, (long)input.available(), -1L).contentType(contentType).build());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @ApiOperation(value="\u4e0b\u8f7d\u6587\u4ef6", notes="\u4e0b\u8f7d\u6587\u4ef6 Download File")
    @GetMapping(value={"/download"})
    public ResponseEntity<byte[]> download(@RequestParam(value="fileId") String fileId) throws IOException {
        ResponseEntity<byte[]> download = null;
        if (StringHelper.isNotEmpty((CharSequence)fileId)) {
            SysFile sysFile = (SysFile)((Object)this.sysFileService.getById((Serializable)((Object)fileId)));
            if (ObjectHelper.isEmpty((Object)((Object)sysFile))) {
                throw new ApiException(FileEnumCode.LOCAL_FILE_NOT_EXISTED.transform());
            }
            String filename = sysFile.getFileName();
            download = this.minioUtilS.download(filename);
        }
        return download;
    }

    @ApiOperation(value="\u5220\u9664\u6587\u4ef6 ", notes="\u6839\u636eid\u5220\u9664\u6587\u4ef6")
    @GetMapping(value={"/delete"})
    public BaseResponse<String> delete(@RequestParam(value="fileId") String fileId) {
        BaseResponse response = new BaseResponse();
        String filename = null;
        if (StringHelper.isNotEmpty((CharSequence)fileId)) {
            SysFile sysFile = (SysFile)((Object)this.sysFileService.getById((Serializable)((Object)fileId)));
            if (ObjectHelper.isEmpty((Object)((Object)sysFile))) {
                throw new ApiException(FileEnumCode.LOCAL_FILE_NOT_EXISTED.transform());
            }
            filename = sysFile.getFileName();
        }
        try {
            this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.bucketName)).object(filename)).build());
            this.sysFileService.removeById((Serializable)((Object)fileId));
        }
        catch (ErrorResponseException e) {
            e.printStackTrace();
        }
        catch (InsufficientDataException e) {
            e.printStackTrace();
        }
        catch (InternalException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidResponseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        catch (XmlParserException e) {
            e.printStackTrace();
        }
        response.setMsg("\u5220\u9664\u6210\u529f");
        return response;
    }

    @ApiOperation(value="\u5220\u9664\u6587\u4ef6 \u57fa\u4e8eFILE_BIZ\u5173\u8054", notes="\u6587\u4ef6\u5220\u9664 \u57fa\u4e8eFILE_BIZ\u5173\u8054")
    @PutMapping(value={"/biz/delete"})
    public BaseResponse<BizGeneralResponse> deleteByBiz(@RequestBody SysFile deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)((Object)deleteRequest)) && StringHelper.isNotEmpty((CharSequence)deleteRequest.getId())) {
            TSysFileBiz tSysFileBiz = new TSysFileBiz();
            List tSysFileBizs = this.tSysFileBizService.list((Wrapper)new QueryWrapper().select(new String[]{"biz_id"}).eq((Object)"file_id", (Object)deleteRequest.getId()));
            boolean result = true;
            for (TSysFileBiz tSysFileBiz1 : tSysFileBizs) {
                result = this.tSysFileBizService.removeById((Serializable)((Object)tSysFileBiz1));
            }
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u5217\u8868", notes="\u83b7\u53d6\u6240\u6709\u6587\u4ef6\u5217\u8868 List SysFile all")
    @GetMapping(value={"/lists"})
    public BaseResponse<BaseResponseList<SysFile>> listAllEntity(SysFileParam param) {
        BaseResponse baseResponse = new BaseResponse();
        QueryWrapper<SysFile> queryWrapper = this.createQuery(param);
        List resultList = this.sysFileService.list((Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal((long)resultList.size());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u6807\u8bc6\u83b7\u53d6\u6587\u4ef6\u5217\u8868-\u5206\u9875", notes="\u6839\u636e\u4e1a\u52a1\u6807\u8bc6\u83b7\u53d6\u6587\u4ef6\u5217\u8868-\u5206\u9875, List File by Biz Params")
    @GetMapping(value={"/biz/list"})
    public BaseResponse<BaseResponseList<SysFile>> listFileEntityByBiz(TSysFileBizParam param) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper<TSysFileBiz> queryWrapper = this.createFileBizQuery(param);
        BaseResponseList baseResponseList = new BaseResponseList();
        Page sysFileBizList = (Page)this.tSysFileBizService.page((IPage)resultPage, (Wrapper)queryWrapper);
        if (!sysFileBizList.getRecords().isEmpty()) {
            List fileIdList = sysFileBizList.getRecords().stream().map(TSysFileBiz::getFileId).collect(Collectors.toList());
            List resultList = this.sysFileService.listByIds(fileIdList);
            baseResponseList.setData(resultList);
            baseResponseList.setTotal((long)resultList.size());
        }
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u6807\u8bc6\u83b7\u53d6\u6587\u4ef6\u5217\u8868", notes="\u6839\u636e\u4e1a\u52a1\u6807\u8bc6\u83b7\u53d6\u6587\u4ef6\u5217\u8868,List File by Biz Params")
    @GetMapping(value={"/biz/datas"})
    public BaseResponse<BaseResponseList<SysFile>> listAllFileEntityByBiz(TSysFileBizParam param) {
        BaseResponse baseResponse = new BaseResponse();
        QueryWrapper<TSysFileBiz> queryWrapper = this.createFileBizQuery(param);
        BaseResponseList baseResponseList = new BaseResponseList();
        List sysFileBizList = this.tSysFileBizService.list((Wrapper)queryWrapper);
        if (!sysFileBizList.isEmpty()) {
            List fileIdList = sysFileBizList.stream().map(TSysFileBiz::getFileId).collect(Collectors.toList());
            List resultList = this.sysFileService.listByIds(fileIdList);
            baseResponseList.setData(resultList);
            baseResponseList.setTotal((long)resultList.size());
        }
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    private QueryWrapper<SysFile> createQuery(SysFileParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc((Object)"update_date");
        }
        return queryWrapper;
    }

    private QueryWrapper<TSysFileBiz> createFileBizQuery(TSysFileBizParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getBizId())) {
            queryWrapper.eq((Object)"biz_id", (Object)queryParam.getBizId());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getBizCode())) {
            queryWrapper.eq((Object)"biz_code", (Object)queryParam.getBizCode());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getBizColCode())) {
            queryWrapper.eq((Object)"biz_col_code", (Object)queryParam.getBizColCode());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getFileId())) {
            queryWrapper.eq((Object)"file_id", (Object)queryParam.getFileId());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        } else {
            queryWrapper.ne((Object)"status", (Object)"1");
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc((Object)"update_date");
        }
        return queryWrapper;
    }
}

