package com.testor.common.translation.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.biz.sys.user.model.domain.SysUser;
import com.testor.biz.sys.user.service.SysUserService;
import com.testor.common.annotation.TranslationType;
import com.testor.common.constant.TransConstant;
import com.testor.common.translation.TranslationInterface;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Component
@AllArgsConstructor
@TranslationType(type = TransConstant.USER_ID_TO_NAME)
public class UserIdTranslationImpl implements TranslationInterface<String> {

    @Autowired
    private SysUserService userService;

    @Override
    public String translation(Object key, String other) {
        String keyStr = key.toString().toString();
        if (keyStr.contains(",")){
            List<SysUser> sysUsers = userService.list(new QueryWrapper<SysUser>().in(SysUser.USER_ID, Arrays.asList(keyStr.split(","))));
            return sysUsers.stream().map(SysUser::getUserName).collect(Collectors.joining(","));
        }else {
            SysUser sysUser = userService.getById(keyStr);
            return sysUser != null ? sysUser.getUserName() : "";
        }
    }
}
