package com.testor.ddd.safetyControl.infrastructure.repository.riskOwner.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.ddd.safetyControl.domain.riskOwner.entity.TSafeRiskOwnerRepo;
import com.testor.ddd.safetyControl.infrastructure.repository.riskOwner.dao.TSafeRiskOwnerDao;
import com.testor.ddd.safetyControl.infrastructure.repository.riskOwner.entity.TSafeRiskOwnerDO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskOwner.TSafeRiskOwnerDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskOwner.TSafeRiskOwnerDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskOwner.TSafeRiskOwnerVO;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 危险源Service业务层处理
 * 
 * @author testor-framework
 * @date 2022-07-11 10:00:17
 */
@Service
public class TSafeRiskOwnerServiceImpl extends SuperServiceImpl<TSafeRiskOwnerDao, TSafeRiskOwnerDO>
        implements TSafeRiskOwnerRepo

{
    @Autowired(required = false)
    private TSafeRiskOwnerDao tSafeRiskOwnerDao;

    public boolean deleteByRiskBizId(String riskBizId){
        UpdateWrapper<TSafeRiskOwnerDO>  updateWrapper = new UpdateWrapper<>();
        updateWrapper.lambda().set(TSafeRiskOwnerDO::getStatus, BizConstants.STATUS_DELETE)
                .ne(TSafeRiskOwnerDO::getStatus, BizConstants.STATUS_DELETE)
                .eq(TSafeRiskOwnerDO::getRiskId, riskBizId);
        return update(updateWrapper);
    }

    public boolean saveBatch(List<TSafeRiskOwnerDTO> riskOwnerDTOList){
        List<TSafeRiskOwnerDO> riskOwnerDOList = BeanHelper.listToList(riskOwnerDTOList, TSafeRiskOwnerDO.class);
        return saveBatch(riskOwnerDOList);
    }

    public BaseResponseList<TSafeRiskOwnerVO> listPage(TSafeRiskOwnerDTOParam param){
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TSafeRiskOwnerVO> resultPage = new Page<>(page, limit);
        IPage<TSafeRiskOwnerVO> iPage = tSafeRiskOwnerDao.listPage(resultPage, param);

        BaseResponseList<TSafeRiskOwnerVO> baseResponseList=new BaseResponseList<>();
        baseResponseList.setData(iPage.getRecords());
        baseResponseList.setTotal(iPage.getTotal());
        return baseResponseList;
    }

    /* Private Methods */
    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TSafeRiskOwnerDO> createQuery(TSafeRiskOwnerDTOParam queryParam){
        QueryWrapper<TSafeRiskOwnerDO> queryWrapper=new QueryWrapper<>();
        if(StringHelper.isNotEmpty(queryParam.getRiskId())){
            queryWrapper.eq(TSafeRiskOwnerDO.RISK_ID,queryParam.getRiskId());
        }
        if(StringHelper.isNotEmpty(queryParam.getUserId())){
            queryWrapper.eq(TSafeRiskOwnerDO.USER_ID,queryParam.getUserId());
        }
        if(ObjectHelper.isNotEmpty(queryParam.getType())){
            queryWrapper.eq(TSafeRiskOwnerDO.TYPE,queryParam.getType());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TSafeRiskOwnerDO.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TSafeRiskOwnerDO.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
            if(StringHelper.isNotEmpty(queryParam.getOrderType())
                    &&BizConstants.ASC.equals(queryParam.getOrderType())){
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            }else{
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        }else{
            queryWrapper.orderByDesc(TSafeRiskOwnerDO.UPDATE_DATE);
        }
        return queryWrapper;
    }

    public TSafeRiskOwnerDTO insert(TSafeRiskOwnerDTO riskOwnerDTO){
        TSafeRiskOwnerDO data = BeanHelper.beanToBean(riskOwnerDTO, TSafeRiskOwnerDO.class);
        int result = tSafeRiskOwnerDao.insert(data);
        if(result < 1) {
            return null;
        }
        riskOwnerDTO = BeanHelper.beanToBean(data, TSafeRiskOwnerDTO.class);
        return riskOwnerDTO;
    }

    @Override
    public List<TSafeRiskOwnerVO> listAll(TSafeRiskOwnerDTOParam param) {
        return tSafeRiskOwnerDao.listAll(param);
    }
}

