package com.testor.module.iam.model.domain;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

/**
 * @ClassName: IamDepartment
 * @Description: TODO
 * @Author: lm
 * @CreateTime: 2024/1/2 15:09
 * @Version: 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("iam_department")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class IamDepartment extends SuperModel {

    /**
     * iam部门id
     */
    @JsonProperty(value="sourceid")
    private String sourceId;

    /**
     * iam上级部门id
     */
    @JsonProperty(value="parentsourceid")
    private String parentSourceId;

    /**
     * 部门名称
     */
    private String name;

    /**
     * 部门简称
     */
    private String shortName;

    /**
     * 部门id
     */
    private String id;

    /**
     * 上级部门id
     */
    @JsonProperty(value="parentid")
    private String parentId;

    /**
     * 排序
     */
    private Integer order;

    /**
     * 启用/禁用机构。1表示启用，0表示禁用
     */
    private Integer enable;

    /**
     * 统一社会信用代码
     */
    private String unifiedSocialCreditCode;

    /**
     * 部门全路径
     */
    private String departmentPath;

}
