package com.testor.module.video.model.dto;

import com.testor.module.video.model.domain.VideoDeviceNumber;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;


/**
 * 视频监控设备信息和粮库对应 删除参数对象
 *
 * @author testor-framework
 * @date 2022-12-14 14:14:44
 */

@Data
@ApiModel(value = "VideoDeviceNumber 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class VideoDeviceNumberParam extends VideoDeviceNumber {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

}
