package com.testor.workflow.task;

import com.tongtech.tfw.backend.common.models.response.ResponseInfo;

/**
 * Task Enum
 *
 * <p>Created by ivan on 2020/8/26.
 */
public enum TaskEnumCode {

  /** 100 */
  CLAIM_FAILED(100, "任务签收失败,请重新确认任务状态"),
  /** 100 */
  COMPLETE_FAILED(100, "任务提交失败,请重新确认任务状态"),
  /** 101 */
  TASK_NOT_FOUND(101, "未找到相关任务信息"),
  ;
  /** Code */
  private final int code;
  /** Message */
  private final String msg;

  TaskEnumCode(int code, String msg) {
    this.code = code;
    this.msg = msg;
  }

  public int code() {
    return code;
  }

  public String msg() {
    return msg;
  }

  public ResponseInfo transform() {
    return ResponseInfo.builder().code(code()).msg(msg()).build();
  }
}
