/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.core;

import com.tongweb.connector.ProtocolHandler;
import com.tongweb.container.ContainerEvent;
import com.tongweb.container.Context;
import com.tongweb.container.Engine;
import com.tongweb.container.Lifecycle;
import com.tongweb.container.LifecycleEvent;
import com.tongweb.container.LifecycleListener;
import com.tongweb.container.Server;
import com.tongweb.container.Service;
import com.tongweb.container.connector.Connector;
import com.tongweb.container.core.FrameworkListener;
import com.tongweb.container.core.StandardContext;
import com.tongweb.container.core.StandardThreadExecutor;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.web.util.res.StringManager;
import com.tongweb.web.util.threads.ThreadPoolExecutor;
import java.util.concurrent.Executor;

public class ThreadLocalLeakPreventionListener
extends FrameworkListener {
    private static final Log log = LogFactory.getLog(ThreadLocalLeakPreventionListener.class);
    private volatile boolean serverStopping = false;
    protected static final StringManager sm = StringManager.getManager(ThreadLocalLeakPreventionListener.class);

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        try {
            super.lifecycleEvent(event);
            Lifecycle lifecycle = event.getLifecycle();
            if ("before_stop".equals(event.getType()) && lifecycle instanceof Server) {
                this.serverStopping = true;
            }
            if ("after_stop".equals(event.getType()) && lifecycle instanceof Context) {
                this.stopIdleThreads((Context)lifecycle);
            }
        }
        catch (Exception e) {
            String msg = sm.getString("threadLocalLeakPreventionListener.lifecycleEvent.error", event);
            log.error(msg, e);
        }
    }

    @Override
    public void containerEvent(ContainerEvent event) {
        try {
            super.containerEvent(event);
        }
        catch (Exception e) {
            String msg = sm.getString("threadLocalLeakPreventionListener.containerEvent.error", event);
            log.error(msg, e);
        }
    }

    private void stopIdleThreads(Context context) {
        if (this.serverStopping) {
            return;
        }
        if (!(context instanceof StandardContext) || !((StandardContext)context).getRenewThreadsWhenStoppingContext()) {
            if (log.isTraceEnabled()) {
                log.trace("Not renewing threads when the context is stopping. It is not configured to do it.");
            }
            return;
        }
        Engine engine = (Engine)context.getParent().getParent();
        Service service = engine.getService();
        Connector[] connectors = service.findConnectors();
        if (connectors != null) {
            for (Connector connector : connectors) {
                ProtocolHandler handler = connector.getProtocolHandler();
                Executor executor = null;
                if (handler != null) {
                    executor = handler.getExecutor();
                }
                if (executor instanceof ThreadPoolExecutor) {
                    ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executor;
                    threadPoolExecutor.contextStopping();
                    continue;
                }
                if (!(executor instanceof StandardThreadExecutor)) continue;
                StandardThreadExecutor stdThreadExecutor = (StandardThreadExecutor)executor;
                stdThreadExecutor.contextStopping();
            }
        }
    }

    @Override
    protected LifecycleListener createLifecycleListener(Context context) {
        return this;
    }
}

