/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.sys.user.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.biz.excel.model.ImportCheckResult;
import com.testor.biz.excel.model.ImportError;
import com.testor.biz.excel.service.ImportCheckService;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.biz.sys.user.UserHelper;
import com.testor.biz.sys.user.model.domain.SysUser;
import com.testor.biz.sys.user.model.dto.UserImport;
import com.testor.biz.sys.user.service.SysUserService;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserExcelImportService
implements ImportCheckService<UserImport> {
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysOrgService sysOrgService;
    private final Map<String, String> orgMap = new HashMap<String, String>();

    @Override
    public ImportCheckResult<UserImport> doImportData(Map<String, UserImport> insertMap, boolean insertTrigger) {
        ArrayList<UserImport> successData = new ArrayList<UserImport>();
        ArrayList errorData = new ArrayList();
        ArrayList<SysUser> insertData = new ArrayList<SysUser>();
        for (String dataId : insertMap.keySet()) {
            UserImport userImport = insertMap.get(dataId);
            String checkResult = this.checkImportData(userImport);
            if (StringHelper.isNotEmpty((CharSequence)checkResult)) {
                ImportError<UserImport> importError = ImportError.builder().errorMsg(checkResult).lineNumber(Integer.parseInt(dataId)).data(userImport).build();
                errorData.add(importError);
                continue;
            }
            successData.add(userImport);
            insertData.add(this.converter(userImport));
        }
        if (!insertData.isEmpty() && insertTrigger) {
            this.sysUserService.saveBatch(insertData);
        }
        return new ImportCheckResult<UserImport>(successData, errorData);
    }

    private SysUser converter(UserImport userImport) {
        SysUser sysUser = (SysUser)((Object)BeanHelper.beanToBean((Object)userImport, SysUser.class));
        String orgName = userImport.getOrgName();
        String orgId = this.orgMap.get(orgName);
        sysUser.setOrgId(orgId);
        sysUser.setUserType("0");
        if (ObjectHelper.isNotEmpty((Object)sysUser.getSex()) && "\u7537".equals(sysUser.getSex().trim())) {
            sysUser.setSex("0");
        } else if (ObjectHelper.isNotEmpty((Object)sysUser.getSex()) && "\u5973".equals(sysUser.getSex().trim())) {
            sysUser.setSex("1");
        }
        sysUser.setStatus("0");
        sysUser.setLoginPwd(UserHelper.userPassword("123456"));
        return sysUser;
    }

    private String checkImportData(UserImport data) {
        String orgMessage;
        StringBuilder result = new StringBuilder();
        SysUser existsSysUser = (SysUser)((Object)this.sysUserService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"login_name", (Object)data.getLoginName())).ne((Object)"status", (Object)"1")).last("LIMIT 1")));
        if (ObjectHelper.isNotEmpty((Object)((Object)existsSysUser))) {
            result.append("\u767b\u5f55\u540d\u5df2\u5b58\u5728").append(";");
        }
        if ((ObjectHelper.isEmpty((Object)this.orgMap.get(data.getOrgName())) || StringHelper.isEmpty((CharSequence)this.orgMap.get(data.getOrgName()))) && !StringHelper.isEmpty((CharSequence)(orgMessage = this.checkOrg(data.getOrgName())))) {
            result.append(orgMessage);
        }
        return result.toString();
    }

    private String checkOrg(String orgNames) {
        StringBuilder result = new StringBuilder();
        String[] orgs = orgNames.split("/");
        String pOrgId = "0";
        String cOrgId = "";
        int counter = 0;
        for (String orgName : orgs) {
            SysOrg sysOrg = (SysOrg)((Object)this.sysOrgService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysOrg::getOrgName, (Object)orgName)).eq(SysOrg::getParentId, (Object)pOrgId)).ne(SuperModel::getStatus, (Object)"1")).last("LIMIT 1")));
            if (ObjectHelper.isNotEmpty((Object)((Object)sysOrg))) {
                pOrgId = sysOrg.getOrgId();
                cOrgId = sysOrg.getOrgId();
                ++counter;
                continue;
            }
            result.append("\u6240\u5c5e\u90e8\u95e8,").append(orgName).append(" \u4e0d\u5b58\u5728");
            break;
        }
        if (counter == orgs.length) {
            this.orgMap.put(orgNames, cOrgId);
        }
        return result.toString();
    }
}

