/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.common.models.exceptions;

import com.tongtech.tfw.backend.common.constants.enumeration.ApiStatusCodeEnum;
import com.tongtech.tfw.backend.common.constants.enumeration.HttpStatusCodeEnum;
import com.tongtech.tfw.backend.common.models.response.ResponseInfo;

public class ServiceException
extends RuntimeException {
    private static final long serialVersionUID = 8340623241530021161L;
    private final ResponseInfo responseInfo;

    public ServiceException(HttpStatusCodeEnum httpStatusCodeEnum) {
        super(httpStatusCodeEnum.msg());
        this.responseInfo = ResponseInfo.transformHttpStatus(httpStatusCodeEnum);
    }

    public ServiceException(ApiStatusCodeEnum apiStatusCodeEnum) {
        super(apiStatusCodeEnum.msg());
        this.responseInfo = ResponseInfo.transformApiStatus(apiStatusCodeEnum);
    }

    public ServiceException(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    public ServiceException(String message) {
        this.responseInfo = new ResponseInfo(400, message);
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }
}

