package com.testor.common.core.enums;

public enum ApiStatusCodeEnum {
    UNKNOWN(996, "未知错误"),
    TOKEN_INVALID(401001, "认证Token无效"),
    JSON_FORMAT_ERROR(400001, "JSON格式错误");

    private final int code;
    private final String msg;

    private ApiStatusCodeEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int code() {
        return this.code;
    }

    public String msg() {
        return this.msg;
    }
}