package com.testor.common.util;

import java.net.MalformedURLException;
import java.net.URL;

/**
 * @author rsq
 * @program zlmy_boot
 * @return
 **/
public class CheckPassword {
    //数字
    public static final String REG_NUMBER = ".*\\d+.*";
    //小写字母
    public static final String REG_UPPERCASE = ".*[A-Z]+.*";
    //大写字母
    public static final String REG_LOWERCASE = ".*[a-z]+.*";
    //特殊符号(~!@#$%^&*()_+|<>,.?/:;'[]{}\)
    public static final String REG_SYMBOL = ".*[~!@#$%^&*()_+|<>,.?/:;'\\[\\]{}\"]+.*";

    public static boolean checkPasswordRule(String password, String username) {

        //密码为空及长度大于8位小于30位判断
        if (password == null || password.length() < 8 || password.length() > 30) return false;

        int i = 0;

        if (password.matches(CheckPassword.REG_NUMBER)) i++;
        if (password.matches(CheckPassword.REG_LOWERCASE)) i++;
        if (password.matches(CheckPassword.REG_UPPERCASE)) i++;
        if (password.matches(CheckPassword.REG_SYMBOL)) i++;

        boolean contains = password.contains(username);

        if (i < 4 || contains) return false;

        return true;
    }


    public static String replaceIpAddressAndPath(String url, String newIpAddress) {
        try {
            URL oldURL = new URL(url);
            String protocol = oldURL.getProtocol();
            String path = oldURL.getPath().replace("/minio", "");
            String newUrl = protocol + "://" + newIpAddress + path;
            return newUrl;
        } catch (MalformedURLException e) {
            e.printStackTrace();
            return url; // Return the original URL if there is an error
        }
    }

}
