package com.testor.ddd.safetyControl.infrastructure.repository.riskMap.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.ddd.safetyControl.domain.riskMap.entity.TSafeRiskMapRepo;
import com.testor.ddd.safetyControl.infrastructure.repository.riskMap.dao.TSafeRiskMapDao;
import com.testor.ddd.safetyControl.infrastructure.repository.riskMap.entity.TSafeRiskMapDO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskMap.TSafeRiskMapDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskMap.TSafeRiskMapDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskMap.TSafeRiskMapVO;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 危险源Service业务层处理
 * 
 * @author testor-framework
 * @date 2022-07-11 10:00:17
 */
@Service
public class TSafeRiskMapServiceImpl extends SuperServiceImpl<TSafeRiskMapDao, TSafeRiskMapDO>
        implements TSafeRiskMapRepo // ,TSafeRiskMapService

{
    @Autowired(required = false)
    private TSafeRiskMapDao tSafeRiskMapDao;

    public TSafeRiskMapDTO insert(TSafeRiskMapDTO riskMapDTO){
        TSafeRiskMapDO data = BeanHelper.beanToBean(riskMapDTO, TSafeRiskMapDO.class);
        int result = tSafeRiskMapDao.insert(data);
        if(result < 1) {
            return null;
        }
        riskMapDTO = BeanHelper.beanToBean(data, TSafeRiskMapDTO.class);
        return riskMapDTO;
    }

    public TSafeRiskMapDTO updateById(TSafeRiskMapDTO riskMapDTO){
        TSafeRiskMapDO data = BeanHelper.beanToBean(riskMapDTO, TSafeRiskMapDO.class);
        int result = tSafeRiskMapDao.updateById(data);
        if(result < 1) {
            return null;
        }
        riskMapDTO = BeanHelper.beanToBean(data, TSafeRiskMapDTO.class);
        return riskMapDTO;
    }

    /**
     * 分页查询
     * @param param
     * @return
     */
    public BaseResponseList<TSafeRiskMapVO> listPage(TSafeRiskMapDTOParam param){
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TSafeRiskMapVO> resultPage = new Page<>(page, limit);
        IPage<TSafeRiskMapVO> iPage = tSafeRiskMapDao.listPage(resultPage, param);

        BaseResponseList<TSafeRiskMapVO> baseResponseList=new BaseResponseList<>();
        baseResponseList.setData(iPage.getRecords());
        baseResponseList.setTotal(iPage.getTotal());
        return baseResponseList;
    }

    public TSafeRiskMapDTO findById(String id){
        if(StrUtil.isBlank(id)) {
            return null;
        }
        TSafeRiskMapDO riskMapDo = tSafeRiskMapDao.selectById(id);
        TSafeRiskMapDTO riskMapDTO = BeanHelper.beanToBean(riskMapDo, TSafeRiskMapDTO.class);
        return riskMapDTO;
    }

    public boolean deleteById(String id){
        UpdateWrapper<TSafeRiskMapDO> updateWrapper = new UpdateWrapper<>();
        updateWrapper.lambda().set(TSafeRiskMapDO::getStatus, BizConstants.STATUS_DELETE)
                .ne(TSafeRiskMapDO::getStatus, BizConstants.STATUS_DELETE)
                .eq(TSafeRiskMapDO::getId,id);
        return update(updateWrapper);
    }

    public List<TSafeRiskMapDTO> listAllEntity(TSafeRiskMapDTOParam param){
        QueryWrapper<TSafeRiskMapDO> queryWrapper=this.createQuery(param);
        List<TSafeRiskMapDO> resultList=list(queryWrapper);
        List<TSafeRiskMapDTO> resultDTOList= BeanHelper.listToList(resultList, TSafeRiskMapDTO.class);
        return resultDTOList;
    }


    /* Private Methods */
    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TSafeRiskMapDO> createQuery(TSafeRiskMapDTOParam queryParam){
        QueryWrapper<TSafeRiskMapDO> queryWrapper=new QueryWrapper<>();
        if(StringHelper.isNotEmpty(queryParam.getOrgId())){
            queryWrapper.eq(TSafeRiskMapDO.ORG_ID,queryParam.getOrgId());
        }
        if(StringHelper.isNotEmpty(queryParam.getName())){
            queryWrapper.like(TSafeRiskMapDO.NAME,queryParam.getName());
        }
        if(ObjectHelper.isNotEmpty(queryParam.getLevel())){
            queryWrapper.eq(TSafeRiskMapDO.LEVEL,queryParam.getLevel());
        }
        if(StringHelper.isNotEmpty(queryParam.getSpaceId())){
            queryWrapper.eq(TSafeRiskMapDO.SPACE_ID,queryParam.getSpaceId());
        }
        if(StringHelper.isNotEmpty(queryParam.getImageId())){
            queryWrapper.eq(TSafeRiskMapDO.IMAGE_ID,queryParam.getImageId());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TSafeRiskMapDO.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TSafeRiskMapDO.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
            if(StringHelper.isNotEmpty(queryParam.getOrderType())
                    &&BizConstants.ASC.equals(queryParam.getOrderType())){
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            }else{
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        }else{
            queryWrapper.orderByDesc(TSafeRiskMapDO.UPDATE_DATE);
        }
        return queryWrapper;
    }

    /**
     * 根据id查看详情
     * @param id
     * @return
     */
    public TSafeRiskMapVO findDetailById(String id) {
        if(StrUtil.isBlank(id)) {
            return null;
        }
        TSafeRiskMapDTOParam param = new TSafeRiskMapDTOParam();
        param.setStatus(BizConstants.STATUS_ENABLE);
        param.setPage("1");
        param.setLimit("1");
        param.setId(id);

        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TSafeRiskMapVO> resultPage = new Page<>(page, limit);
        IPage<TSafeRiskMapVO> iPage = tSafeRiskMapDao.listPage(resultPage, param);
        List<TSafeRiskMapVO> riskMapVOList = iPage.getRecords();
        if(riskMapVOList == null || riskMapVOList.size() == 0) {
            return null;
        }
        TSafeRiskMapVO riskMapVO = riskMapVOList.get(0);
        return riskMapVO;
    }

    /**
     * 列表不分页
     * @param param
     * @return
     */
    public List<TSafeRiskMapDTO> listAll(TSafeRiskMapDTOParam param){

        QueryWrapper<TSafeRiskMapDO> queryWrapper=this.createQuery(param);
        List<TSafeRiskMapDO> resultList= this.list(queryWrapper);

        List<TSafeRiskMapDTO> riskPointDTOList = BeanHelper.listToList(resultList, TSafeRiskMapDTO.class);
        return riskPointDTOList;
    }

    /**
     * 检测 名称 是否都唯一
     * @return true - 唯一； false - 不唯一
     */
    public List<TSafeRiskMapDTO> checkUniqueness(String orgId, String sourceId, String name){
        LambdaQueryWrapper<TSafeRiskMapDO> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TSafeRiskMapDO::getOrgId, orgId)
                .eq(TSafeRiskMapDO::getStatus, BizConstants.STATUS_ENABLE)
               .eq(TSafeRiskMapDO::getName, name) ;
        if(!StrUtil.isBlank(sourceId)) {
            queryWrapper.ne(TSafeRiskMapDO::getId, sourceId);
        }
        List<TSafeRiskMapDO> sourceDOList = tSafeRiskMapDao.selectList(queryWrapper);
        List<TSafeRiskMapDTO> sourceDTOList = BeanHelper.listToList(sourceDOList, TSafeRiskMapDTO.class);
        return sourceDTOList;
    }

}

