package com.testor.module.contractor.manage.model.dto;

import com.testor.module.contractor.manage.model.domain.TContractorEvaluateDetail;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.List;
import java.util.Map;

import com.testor.module.contractor.manage.model.domain.TContractorEvaluate;

/**
 * 承包商考核评价 删除参数对象
 *
 * @author testor-framework
 * @date 2024-11-30 15:42:18
 */

@Data
@ApiModel(value = "TContractorEvaluate 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TContractorEvaluateParam extends TContractorEvaluate {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

	@ApiModelProperty(value = "承包商名称")
	private String contractorName;

	@ApiModelProperty(value = "待办任务id")
	private String taskId;

	@ApiModelProperty(value = "审批参数")
	private Map<String, Object> vars;

	@ApiModelProperty(value = "评价详情")
	private List<TContractorEvaluateDetail> evaluateDetails;

}
