package com.testor.module.messageNotice.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.messageNotice.dao.TSysMsgRemindConfDao;
import com.testor.module.messageNotice.model.domain.TSysMsgRemindConf;
import com.testor.module.messageNotice.model.dto.TSysMsgRemindConfParam;
import com.testor.module.messageNotice.service.TSysMsgRemindConfService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 功能配置-消息提醒配置Service业务层处理
 * 
 * @author testor-framework
 * @date 2022-08-19 16:56:31
 */
@Service
public class TSysMsgRemindConfServiceImpl extends SuperServiceImpl<TSysMsgRemindConfDao, TSysMsgRemindConf> implements TSysMsgRemindConfService
{
    @Autowired(required = false)
    private TSysMsgRemindConfDao tSysMsgRemindConfDao;

    // 分页
    @Override
    public  BaseResponseList<TSysMsgRemindConf> listEntity(TSysMsgRemindConfParam param){

        Long page=
                StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
        Long limit=
                StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
        Page<TSysMsgRemindConf> resultPage=new Page<>(page,limit);
        QueryWrapper<TSysMsgRemindConf> queryWrapper=this.createQuery(param);
        Page<TSysMsgRemindConf> resultList= page(resultPage,queryWrapper);
        BaseResponseList<TSysMsgRemindConf> baseResponseList=new BaseResponseList<>();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());

        return baseResponseList;
    }

    public List<TSysMsgRemindConf> listAllEntity(TSysMsgRemindConfParam param){

        QueryWrapper<TSysMsgRemindConf> queryWrapper=this.createQuery(param);
        List<TSysMsgRemindConf> resultList= list(queryWrapper);
        return resultList;
    }

    /* Private Methods */
    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TSysMsgRemindConf> createQuery(TSysMsgRemindConfParam queryParam){
        QueryWrapper<TSysMsgRemindConf> queryWrapper=new QueryWrapper<>();
        if(ObjectHelper.isNotEmpty(queryParam.getType())){
            queryWrapper.eq(TSysMsgRemindConf.TYPE,queryParam.getType());
        }
        if(StringHelper.isNotEmpty(queryParam.getName())){
            queryWrapper.like(TSysMsgRemindConf.NAME,queryParam.getName());
        }
        if(ObjectHelper.isNotEmpty(queryParam.getUnit())){
            queryWrapper.eq(TSysMsgRemindConf.UNIT,queryParam.getUnit());
        }
        if(ObjectHelper.isNotEmpty(queryParam.getValue())){
            queryWrapper.eq(TSysMsgRemindConf.VALUE,queryParam.getValue());
        }
        if(StringHelper.isNotEmpty(queryParam.getFrequencyKey())){
            queryWrapper.eq(TSysMsgRemindConf.FREQUENCY_KEY,queryParam.getFrequencyKey());
        }
        if(StringHelper.isNotEmpty(queryParam.getCronExpression())){
            queryWrapper.eq(TSysMsgRemindConf.CRON_EXPRESSION,queryParam.getCronExpression());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TSysMsgRemindConf.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TSysMsgRemindConf.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
            if(StringHelper.isNotEmpty(queryParam.getOrderType())
                    &&BizConstants.ASC.equals(queryParam.getOrderType())){
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            }else{
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        }else{
            queryWrapper.orderByDesc(TSysMsgRemindConf.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
