package com.testor.module.safeCheck.model.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;


/**
 * 巡检计划对象 t_safe_hazard_check_plan
 * 
 * @author testor-framework
 * @date 2022-08-04 11:07:52
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_hazard_check_plan")
@ApiModel(value = "TSafeHazardCheckPlan对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeHazardCheckPlan extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  @TableId(value = "id",type = IdType.ASSIGN_UUID)
  private String id;
/**
 * 排查单位id
 */
  @ApiModelProperty(value = "排查单位id")

  @TableField("org_id")
  private String orgId;
/**
 * 被排查单位id
 */
  @ApiModelProperty(value = "被排查单位id")

  @TableField("checked_org_id")
  private String checkedOrgId;
/**
 * 名称
 */
  @ApiModelProperty(value = "名称")

  @TableField("name")
  private String name;
/**
 * 编码
 */
  @ApiModelProperty(value = "编码")

  @TableField("code")
  private String code;
/**
 * 计划开始时间
 */
  @ApiModelProperty(value = "计划开始时间")

  @TableField("start_date")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startDate;
/**
 * 计划结束时间
 */
  @ApiModelProperty(value = "计划结束时间")

  @TableField("end_date")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endDate;
/**
 * 是否双休日(0-不包含，跳过；1-包含，不跳过)
 */
  @ApiModelProperty(value = "是否双休日(0-不包含，跳过；1-包含，不跳过)")

  @TableField("in_weekend")
  private String inWeekend;
/**
 * 是否跳过节假日(0-不包含，跳过；1-包含，不跳过)
 */
  @ApiModelProperty(value = "是否跳过节假日(0-不包含，跳过；1-包含，不跳过)")

  @TableField("in_holiday")
  private String inHoliday;
/**
 * 提前小时
 */
  @ApiModelProperty(value = "提前小时(根据cron表达式 提前时间不能大于两次任务的间隔时间:任务的第二次时间-计划的提前时间 不能小于 当前时间)" , example = "0")

  @TableField("advance_hour")
  private Long advanceHour;

  @ApiModelProperty(value = "被排查单位层级id")
  @TableField("checked_org_parent_ids")
  private String checkedOrgParentIds;

  public static final String ID ="id";
  public static final String ORG_ID ="org_id";
  public static final String CHECKED_ORG_ID ="checked_org_id";
  public static final String NAME ="name";
  public static final String CODE ="code";
  public static final String START_DATE ="start_date";
  public static final String END_DATE ="end_date";
  public static final String IN_WEEKEND ="in_weekend";
  public static final String IN_HOLIDAY ="in_holiday";
  public static final String ADVANCE_HOUR ="advance_hour";


}
