package com.testor.module.train.examinationManage.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;


import java.util.Date;


/**
 * 考试管理—安全培训教育对象 t_train_examination_manage
 *
 * @author testor-framework
 * @date 2022-09-07 11:43:25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_train_examination_manage")
@ApiModel(value = "TTrainExaminationManage对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TTrainExaminationManage extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")

    @TableId("id")
    private String id;
    /**
     * 是否补考  1 是 0 否
     */
    @ApiModelProperty(value = "是否补考  1 是 0 否")

    @TableField("is_repair")
    private String isRepair;
    /**
     * 父级ID (相关补考)
     */
    @ApiModelProperty(value = "父级ID (相关补考)")

    @TableField("parent_id")
    private String parentId;
    /**
     * 考试名称
     */
    @ApiModelProperty(value = "考试名称")

    @TableField("exam_name")
    private String examName;
    /**
     * 考试方式 0 (集体考试)线上 1 (集体考试)线下 3 (随机考试)线上
     */
    @ApiModelProperty(value = "考试方式 0 (集体考试)线上 1 (集体考试)线下 3 (随机考试)线上")

    @TableField("exam_way")
    private String examWay;
    /**
     * 考试类型
     */
    @ApiModelProperty(value = "考试类型")

    @TableField("exam_type")
    private String examType;
    /**
     * 考试开始时间
     */
    @ApiModelProperty(value = "考试开始时间")

    @TableField("exam_start_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date examStartTime;
    /**
     * 考试结束时间
     */
    @ApiModelProperty(value = "考试结束时间")

    @TableField("exam_end_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date examEndTime;
    /**
     * 关联试卷id
     */
    @ApiModelProperty(value = "关联试卷id")

    @TableField("paper_id")
    private String paperId;
    /**
     * 考试时长
     */
    @ApiModelProperty(value = "考试时长")

    @TableField("exam_duration")
    private String examDuration;
    /**
     * 考试地点
     */
    @ApiModelProperty(value = "考试地点")

    @TableField("exam_site")
    private String examSite;
    /**
     * 应考人数
     */
    @ApiModelProperty(value = "应考人数")

    @TableField("should_test_number")
    private String shouldTestNumber;
    /**
     * 完成人数
     */
    @ApiModelProperty(value = "完成人数")

    @TableField("finish_number")
    private String finishNumber;
    /**
     * 完成率
     */
    @ApiModelProperty(value = "完成率")

    @TableField("percentage")
    private String percentage;
    /**
     * 发布单位
     */
    @ApiModelProperty(value = "发布单位")

    @TableField("org_name")
    private String orgName;
    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "组织机构id")

    @TableField("org_id")
    private String orgId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")

    @TableField("tenant_id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")

    @TableField("process_id")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")

    @TableField("process_status")
    private String processStatus;

    @ApiModelProperty(value = "随机线上考试二维码")
    @TableField("qr_code")
    private String qrCode;

    public static final String ID = "id";
    public static final String IS_REPAIR = "is_repair";
    public static final String PARENT_ID = "parent_id";
    public static final String EXAM_NAME = "exam_name";
    public static final String EXAM_WAY = "exam_way";
    public static final String EXAM_TYPE = "exam_type";
    public static final String EXAM_START_TIME = "exam_start_time";
    public static final String EXAM_END_TIME = "exam_end_time";
    public static final String PAPER_ID = "paper_id";
    public static final String EXAM_DURATION = "exam_duration";
    public static final String EXAM_SITE = "exam_site";
    public static final String SHOULD_TEST_NUMBER = "should_test_number";
    public static final String FINISH_NUMBER = "finish_number";
    public static final String PERCENTAGE = "percentage";
    public static final String ORG_NAME = "org_name";
    public static final String ORG_ID = "org_id";
    public static final String TENANT_ID = "tenant_id";
    public static final String PROCESS_ID = "process_id";
    public static final String PROCESS_STATUS = "process_status";
    public static final String QR_CODE = "qr_code";


}
