/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class LoaderCache {
    private static final Map<ClassLoader, LoaderCache> cacheMap = new HashMap<ClassLoader, LoaderCache>();
    private static final Object NULL_OBJECT = new Object();
    private static int cacheThreshold = 2;
    private static String[] filterSuffix;
    private final ConcurrentHashMap<String, CachedObject> getResourceAsStreamCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CachedObject> findResourcesCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CachedObject> getResourcesCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CachedObject> findResourceCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CachedObject> getResourceCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CachedObject> loadClassCache = new ConcurrentHashMap();

    private LoaderCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeClassloader(ClassLoader classLoader) {
        Map<ClassLoader, LoaderCache> map = cacheMap;
        synchronized (map) {
            cacheMap.remove(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoaderCache getInstance(ClassLoader loader) {
        LoaderCache loaderCache;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if ((loaderCache = cacheMap.get(loader)) == null) {
            Map<ClassLoader, LoaderCache> map = cacheMap;
            synchronized (map) {
                loaderCache = cacheMap.get(loader);
                if (loaderCache == null) {
                    loaderCache = new LoaderCache();
                    cacheMap.put(loader, loaderCache);
                }
            }
        }
        return loaderCache;
    }

    private static Object getObjectFromCache(String name, Callback<Object> callback, ConcurrentHashMap<String, CachedObject> cache) throws Throwable {
        if (filterSuffix != null) {
            for (String f : filterSuffix) {
                if (!name.endsWith(f)) continue;
                return callback.callback();
            }
        }
        CachedObject cachedObject = cache.computeIfAbsent(name, s -> new CachedObject());
        if (cachedObject.tryTimes.get() > cacheThreshold) {
            if (cachedObject.cache == null) {
                Object obj = callback.callback();
                if (obj == null) {
                    obj = NULL_OBJECT;
                }
                cachedObject.cache = obj;
            }
            return cachedObject.cache == NULL_OBJECT ? null : cachedObject.cache;
        }
        cachedObject.tryTimes.incrementAndGet();
        return callback.callback();
    }

    public void close() {
        this.getResourceAsStreamCache.clear();
        this.findResourcesCache.clear();
        this.getResourcesCache.clear();
        this.findResourceCache.clear();
        this.getResourceCache.clear();
        this.loadClassCache.clear();
    }

    private Enumeration<URL> getEnumerationURL(String name, Callback<Enumeration<URL>> callback, ConcurrentHashMap<String, CachedObject> listURLCache) throws Throwable {
        Object cachedObj = LoaderCache.getObjectFromCache(name, () -> {
            Enumeration result = (Enumeration)callback.callback();
            if (result != null) {
                ArrayList<URL> urlList = new ArrayList<URL>();
                while (result.hasMoreElements()) {
                    URL url = (URL)result.nextElement();
                    urlList.add(url);
                }
                return urlList;
            }
            return null;
        }, listURLCache);
        return cachedObj == null ? null : Collections.enumeration((List)cachedObj);
    }

    private URL getURLCache(String name, Callback<URL> callback, ConcurrentHashMap<String, CachedObject> URLCache) throws Throwable {
        Object cachedObj = LoaderCache.getObjectFromCache(name, callback::callback, URLCache);
        return cachedObj == null ? null : (URL)cachedObj;
    }

    public Class<?> loadClass(String name, Callback<?> callback) throws Throwable {
        Object cachedObj = null;
        try {
            cachedObj = LoaderCache.getObjectFromCache(name, callback::callback, this.loadClassCache);
        }
        catch (Throwable throwable) {
            if (throwable instanceof LinkageError) {
                cachedObj = LoaderCache.getObjectFromCache(name, callback::callback, this.loadClassCache);
            }
            throw throwable;
        }
        return cachedObj == null ? null : (Class)cachedObj;
    }

    public InputStream getResourceAsStream(String name, Callback<InputStream> callback) throws Throwable {
        Object cachedObj = LoaderCache.getObjectFromCache(name, () -> {
            try (InputStream realStream = (InputStream)callback.callback();){
                if (realStream != null) {
                    int n;
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[4096];
                    long count = 0L;
                    while (-1 != (n = realStream.read(buffer))) {
                        bos.write(buffer, 0, n);
                        count += (long)n;
                    }
                    bos.flush();
                    byte[] byArray = bos.toByteArray();
                    return byArray;
                }
                Object var2_3 = null;
                return var2_3;
            }
        }, this.getResourceAsStreamCache);
        return cachedObj == null ? null : new ByteArrayInputStream((byte[])cachedObj);
    }

    public Enumeration<URL> findResources(String name, Callback<Enumeration<URL>> callback) throws Throwable {
        return this.getEnumerationURL(name, callback, this.findResourcesCache);
    }

    public Enumeration<URL> getResources(String name, Callback<Enumeration<URL>> callback) throws Throwable {
        return this.getEnumerationURL(name, callback, this.getResourcesCache);
    }

    public URL findResource(String name, Callback<URL> callback) throws Throwable {
        return this.getURLCache(name, callback, this.findResourceCache);
    }

    public URL getResource(String name, Callback<URL> callback) throws Throwable {
        return this.getURLCache(name, callback, this.getResourceCache);
    }

    static {
        try {
            String threshold = System.getProperty("tongweb.cache.threshold");
            if (threshold != null) {
                cacheThreshold = Integer.parseInt(threshold);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String cacheFilterSuffix = System.getProperty("tongweb.cache.filter");
            if (cacheFilterSuffix != null) {
                String[] split = cacheFilterSuffix.split(",");
                HashSet<String> filters = new HashSet<String>();
                for (String sf : split) {
                    if (sf == null || sf.trim().isEmpty()) continue;
                    filters.add(sf.trim());
                }
                if (!filters.isEmpty()) {
                    filterSuffix = filters.toArray(new String[0]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface Callback<T> {
        public T callback() throws Throwable;
    }

    private static class CachedObject {
        volatile AtomicInteger tryTimes = new AtomicInteger(0);
        volatile Object cache;

        private CachedObject() {
        }
    }
}

