/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.workflow.apis.instance.service.impl;

import com.tongtech.tfw.workflow.apis.instance.service.ProcessInsService;
import com.tongtech.tfw.workflow.apis.support.BpmnDiagramGenerator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.common.engine.impl.util.IoUtil;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.runtime.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessInsServiceImpl
implements ProcessInsService {
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private BpmnDiagramGenerator bpmnDiagramGenerator;

    @Override
    public String suspendOrActiveProcessInsById(String processInstanceId, int processState) {
        String result = "\u64cd\u4f5c\u5931\u8d25";
        if (1 == processState) {
            this.runtimeService.activateProcessInstanceById(processInstanceId);
            result = "\u6fc0\u6d3b\u6210\u529f";
        } else if (0 == processState) {
            this.runtimeService.suspendProcessInstanceById(processInstanceId);
            result = "\u6302\u8d77\u6210\u529f";
        }
        return result;
    }

    @Override
    public String stopInsById(String processInstanceId, String comments) {
        String result = "\u64cd\u4f5c\u5931\u8d25";
        try {
            this.runtimeService.deleteProcessInstance(processInstanceId, comments);
            result = "\u5220\u9664\u6210\u529f";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public byte[] processInsTrackById(String processInstanceId) {
        String processDefinitionId;
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        ArrayList<String> activeActivityIds = new ArrayList();
        ArrayList<String> highLightedFlows = new ArrayList<String>();
        List historicSquenceFlows = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityType("sequenceFlow").list();
        historicSquenceFlows.forEach(historicActivityInstance -> highLightedFlows.add(historicActivityInstance.getActivityId()));
        if (processInstance != null) {
            processDefinitionId = processInstance.getProcessDefinitionId();
            activeActivityIds = this.runtimeService.getActiveActivityIds(processInstanceId);
        } else {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            processDefinitionId = historicProcessInstance.getProcessDefinitionId();
            List historicEnds = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityType("endEvent").list();
            ArrayList<String> finalActiveActivityIds = activeActivityIds;
            historicEnds.forEach(historicActivityInstance -> finalActiveActivityIds.add(historicActivityInstance.getActivityId()));
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        InputStream inputStream = this.bpmnDiagramGenerator.generateDiagram(bpmnModel, activeActivityIds, highLightedFlows);
        return IoUtil.readInputStream((InputStream)inputStream, (String)"bpmn diagram in");
    }
}

