/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.monitor.core.instrument.step;

import com.tongweb.commons.monitor.core.instrument.Clock;
import com.tongweb.commons.monitor.core.instrument.Counter;
import com.tongweb.commons.monitor.core.instrument.DistributionSummary;
import com.tongweb.commons.monitor.core.instrument.FunctionCounter;
import com.tongweb.commons.monitor.core.instrument.FunctionTimer;
import com.tongweb.commons.monitor.core.instrument.Gauge;
import com.tongweb.commons.monitor.core.instrument.LongTaskTimer;
import com.tongweb.commons.monitor.core.instrument.Measurement;
import com.tongweb.commons.monitor.core.instrument.Meter;
import com.tongweb.commons.monitor.core.instrument.MeterRegistry;
import com.tongweb.commons.monitor.core.instrument.Timer;
import com.tongweb.commons.monitor.core.instrument.distribution.DistributionStatisticConfig;
import com.tongweb.commons.monitor.core.instrument.distribution.HistogramGauges;
import com.tongweb.commons.monitor.core.instrument.distribution.pause.PauseDetector;
import com.tongweb.commons.monitor.core.instrument.internal.DefaultGauge;
import com.tongweb.commons.monitor.core.instrument.internal.DefaultLongTaskTimer;
import com.tongweb.commons.monitor.core.instrument.internal.DefaultMeter;
import com.tongweb.commons.monitor.core.instrument.push.PushMeterRegistry;
import com.tongweb.commons.monitor.core.instrument.step.StepCounter;
import com.tongweb.commons.monitor.core.instrument.step.StepDistributionSummary;
import com.tongweb.commons.monitor.core.instrument.step.StepFunctionCounter;
import com.tongweb.commons.monitor.core.instrument.step.StepFunctionTimer;
import com.tongweb.commons.monitor.core.instrument.step.StepRegistryConfig;
import com.tongweb.commons.monitor.core.instrument.step.StepTimer;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public abstract class StepMeterRegistry
extends PushMeterRegistry {
    private final StepRegistryConfig config;

    public StepMeterRegistry(StepRegistryConfig config, Clock clock) {
        super(config, clock);
        this.config = config;
    }

    @Override
    protected <T> Gauge newGauge(Meter.Id id, T obj, ToDoubleFunction<T> valueFunction) {
        return new DefaultGauge<T>(id, obj, valueFunction);
    }

    @Override
    protected Counter newCounter(Meter.Id id) {
        return new StepCounter(id, this.clock, this.config.step().toMillis());
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        DefaultLongTaskTimer ltt = new DefaultLongTaskTimer(id, this.clock, this.getBaseTimeUnit(), distributionStatisticConfig, false);
        HistogramGauges.registerWithCommonFormat(ltt, (MeterRegistry)this);
        return ltt;
    }

    @Override
    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        StepTimer timer = new StepTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit(), this.config.step().toMillis(), false);
        HistogramGauges.registerWithCommonFormat(timer, (MeterRegistry)this);
        return timer;
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        StepDistributionSummary summary = new StepDistributionSummary(id, this.clock, distributionStatisticConfig, scale, this.config.step().toMillis(), false);
        HistogramGauges.registerWithCommonFormat(summary, (MeterRegistry)this);
        return summary;
    }

    @Override
    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        return new StepFunctionTimer<T>(id, this.clock, this.config.step().toMillis(), obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit());
    }

    @Override
    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        return new StepFunctionCounter<T>(id, this.clock, this.config.step().toMillis(), obj, countFunction);
    }

    @Override
    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return new DefaultMeter(id, type, measurements);
    }

    @Override
    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.config.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }
}

