/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.common.log;

import com.tongtech.tfw.backend.common.context.ContextHelper;
import com.tongtech.tfw.backend.common.models.log.HttpCallLogInfo;
import com.tongtech.tfw.backend.common.request.RequestUtil;
import com.tongtech.tfw.backend.common.response.ResponseWrapper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.json.JacksonHelper;
import com.tongtech.tfw.backend.core.models.exceptions.FrameworkException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCallLogHelper {
    private static final Logger log = LoggerFactory.getLogger(HttpCallLogHelper.class);

    public static void printHttpCallLogInfo(HttpServletRequest request, ResponseWrapper response, Object result) {
        HttpCallLogHelper.printHttpCallLogInfo((String)request.getAttribute("requestId"), RequestUtil.getParameterMap(request), RequestUtil.getRequestBody(request), (String)request.getAttribute("url"), (String)request.getAttribute("mapping"), (String)request.getAttribute("method"), result, (Long)request.getAttribute("startTime"), RequestUtil.getIpAddr(request), (String)request.getAttribute("user_id"));
    }

    public static void printHttpCallLogInfo(String requestId, Map<String, String[]> parameterMap, String requestBody, String url, String mapping, String method, Object result, Long runTime, String ip, String appId) {
        HttpCallLogInfo requestLogInfo = HttpCallLogInfo.builder().requestId(requestId).ip(ip).mapping(mapping).method(method).parameterMap(parameterMap).requestBody(Optional.ofNullable(JacksonHelper.readValue((String)requestBody)).orElse(requestBody)).result(result).runTime((null != runTime ? System.nanoTime() - runTime : 0L) + " ns").url(url).appId(appId).build();
        log.info(JacksonHelper.toJson((Object)requestLogInfo));
    }

    public static void logRecord(HttpServletRequest request, ResponseWrapper response, Object result) {
        Executor executor = (Executor)ContextHelper.getBeanByName("TongAsyncExecutor");
        if (ObjectHelper.isEmpty((Object)executor)) {
            executor = ForkJoinPool.commonPool();
        }
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            Object logService = ContextHelper.getObjectBean("LogService");
            if (ObjectHelper.isNotEmpty((Object)logService)) {
                Method[] a;
                for (Method m : a = logService.getClass().getMethods()) {
                    if (!m.getName().equals("saveLog")) continue;
                    try {
                        m.invoke(logService, new Object[]{request, response, result});
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        log.error("Warn: Log Service Error ", (Throwable)e);
                    }
                }
            }
        }, executor);
        try {
            future.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new FrameworkException((Throwable)e);
        }
    }
}

