/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.core.helper.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.tongtech.tfw.backend.core.constants.enumeration.JsonNamingStrategyEnum;
import com.tongtech.tfw.backend.core.models.exceptions.FrameworkException;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public class JacksonHelper {
    private static final ObjectMapper objectMapper = JacksonHelper.getObjectMapper(new ObjectMapper());

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static ObjectMapper getObjectMapper(ObjectMapper thirdMapper) {
        if (Objects.isNull(thirdMapper)) {
            return objectMapper;
        }
        return JacksonHelper.configureObjectMapper(thirdMapper);
    }

    public static void setLowCamelCaseMapper() {
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CAMEL_CASE);
    }

    public static void setSnakeCaseMapper() {
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
    }

    static ObjectMapper configureObjectMapper(ObjectMapper objectMapper) {
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CAMEL_CASE);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.enable(new MapperFeature[]{MapperFeature.PROPAGATE_TRANSIENT_MARKER});
        objectMapper.enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER.mappedFeature()});
        JacksonHelper.registerJavaTime(objectMapper);
        JacksonHelper.registerLongSerializer(objectMapper);
        return objectMapper;
    }

    public static void registerNullSerializer(ObjectMapper objectMapper) {
        objectMapper.getSerializerProvider().setNullValueSerializer((JsonSerializer)new JsonSerializer<Object>(){

            public void serialize(Object paramT, JsonGenerator paramJsonGenerator, SerializerProvider paramSerializerProvider) throws IOException {
                paramJsonGenerator.writeString("");
            }
        });
    }

    public static void registerJavaTime(ObjectMapper objectMapper) {
        objectMapper.registerModule((Module)new JavaTimeModule());
        SimpleModule jsr310Module = new SimpleModule();
        jsr310Module.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        jsr310Module.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        jsr310Module.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        jsr310Module.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        jsr310Module.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        jsr310Module.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        objectMapper.registerModule((Module)jsr310Module);
    }

    public static void registerLongSerializer(ObjectMapper objectMapper) {
        SimpleModule long2StringModule = new SimpleModule();
        long2StringModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
    }

    public static Object readValue(String jsonString) {
        Object object = null;
        try {
            object = JacksonHelper.getObjectMapper().readValue(jsonString, Object.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public static Object readValue(String jsonString, JsonNamingStrategyEnum jsonNameStrategy) {
        Object object = null;
        if (JsonNamingStrategyEnum.LOWER_CAMEL_CASE.equals((Object)jsonNameStrategy)) {
            object = JacksonHelper.readValue(jsonString);
        } else if (JsonNamingStrategyEnum.SNAKE_CASE.equals((Object)jsonNameStrategy)) {
            JacksonHelper.setSnakeCaseMapper();
            object = JacksonHelper.readValue(jsonString);
            JacksonHelper.setLowCamelCaseMapper();
        }
        return object;
    }

    public static <T> T readValue(String json, Class<T> clazz) {
        Object t;
        try {
            t = JacksonHelper.getObjectMapper().readValue(json, clazz);
        }
        catch (Exception ignore) {
            throw new FrameworkException("Unable to read JSON value: " + json, ignore);
        }
        return (T)t;
    }

    public static <T> T readValue(String json, Class<T> clazz, JsonNamingStrategyEnum jsonNameStrategy) {
        T t = null;
        try {
            if (JsonNamingStrategyEnum.LOWER_CAMEL_CASE.equals((Object)jsonNameStrategy)) {
                t = JacksonHelper.readValue(json, clazz);
            } else if (JsonNamingStrategyEnum.SNAKE_CASE.equals((Object)jsonNameStrategy)) {
                JacksonHelper.setSnakeCaseMapper();
                t = JacksonHelper.readValue(json, clazz);
                JacksonHelper.setLowCamelCaseMapper();
            }
        }
        catch (Exception ignore) {
            throw new FrameworkException(ignore);
        }
        return t;
    }

    public static <T> T readValue(String json, TypeReference<T> valueTypeRef) {
        Object t;
        try {
            t = JacksonHelper.getObjectMapper().readValue(json, valueTypeRef);
        }
        catch (Exception ignore) {
            throw new FrameworkException(ignore);
        }
        return (T)t;
    }

    public static <T> T readValue(String json, TypeReference<T> valueTypeRef, JsonNamingStrategyEnum jsonNameStrategy) {
        T t = null;
        try {
            if (JsonNamingStrategyEnum.LOWER_CAMEL_CASE.equals((Object)jsonNameStrategy)) {
                t = JacksonHelper.readValue(json, valueTypeRef);
            } else if (JsonNamingStrategyEnum.SNAKE_CASE.equals((Object)jsonNameStrategy)) {
                JacksonHelper.setSnakeCaseMapper();
                t = JacksonHelper.readValue(json, valueTypeRef);
                JacksonHelper.setLowCamelCaseMapper();
            }
        }
        catch (Exception ignore) {
            throw new FrameworkException(ignore);
        }
        return t;
    }

    public static String toJson(Object object) {
        if (Objects.nonNull(object) && CharSequence.class.isAssignableFrom(object.getClass())) {
            return object.toString();
        }
        try {
            return JacksonHelper.getObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException ignore) {
            throw new FrameworkException(ignore);
        }
    }

    static class XssStringJsonSerializer
    extends JsonSerializer<String> {
        XssStringJsonSerializer() {
        }

        public Class<String> handledType() {
            return String.class;
        }

        public void serialize(String value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (value != null) {
                jsonGenerator.writeString(value);
            }
        }
    }
}

