/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.auth.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.testor.biz.auth.model.AuthModel;
import com.testor.biz.auth.model.RoleResourceModel;
import com.testor.biz.auth.model.UserInfo;
import com.testor.biz.auth.model.UserInfoResponse;
import com.testor.biz.auth.model.UserResource;
import com.testor.biz.auth.model.UserRole;
import com.testor.biz.auth.service.AuthService;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.biz.sys.resource.model.domain.SysResource;
import com.testor.biz.sys.resource.service.SysResourceService;
import com.testor.biz.sys.role.model.domain.SysRole;
import com.testor.biz.sys.role.service.SysRoleService;
import com.testor.biz.sys.roleResource.model.domain.SysRoleResource;
import com.testor.biz.sys.roleResource.service.SysRoleResourceService;
import com.testor.biz.sys.user.model.domain.SysUser;
import com.testor.biz.sys.user.service.SysUserService;
import com.testor.biz.sys.userRole.service.SysUserRoleService;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthServiceImpl
implements AuthService {
    private static final Logger log = LoggerFactory.getLogger(AuthServiceImpl.class);
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private SysResourceService sysResourceService;
    @Autowired
    private SysUserRoleService sysUserRoleService;
    @Autowired
    private SysRoleResourceService sysRoleResourceService;
    @Autowired
    private SysOrgService sysOrgService;

    @Override
    public SysUser login(String loginName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"login_name", (Object)loginName)).ne((Object)"status", (Object)"1")).last("LIMIT 1");
        SysUser sysUser = (SysUser)((Object)this.sysUserService.getOne((Wrapper)queryWrapper));
        if (ObjectHelper.isNotEmpty((Object)((Object)sysUser))) {
            return sysUser;
        }
        return null;
    }

    @Override
    public SysUser loginByKey(String loginName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"user_key_pid", (Object)loginName)).ne((Object)"status", (Object)"1")).last("LIMIT 1");
        SysUser sysUser = (SysUser)((Object)this.sysUserService.getOne((Wrapper)queryWrapper));
        if (ObjectHelper.isNotEmpty((Object)((Object)sysUser))) {
            return sysUser;
        }
        return null;
    }

    @Override
    public List<AuthModel> getResources(String resourceUrl) {
        LambdaQueryWrapper resourceWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{SysResource::getResourceUrl, SysResource::getResourceId, SysResource::getResourceAuthType, SysResource::getResourceType}).eq(SysResource::getResourceUrl, (Object)resourceUrl)).ne(SuperModel::getStatus, (Object)"1");
        return this.sysResourceService.list((Wrapper)resourceWrapper).stream().map(e -> (AuthModel)e.beanToBean(AuthModel.class)).collect(Collectors.toList());
    }

    @Override
    public RoleResourceModel loadRoleResource(String userId) {
        RoleResourceModel roleResourceModel = new RoleResourceModel();
        List<String> roleList = this.sysUserRoleService.getRoles(userId);
        ArrayList<String> resourceList = new ArrayList<String>(200);
        for (String role : roleList) {
            resourceList.addAll(this.sysRoleResourceService.getResources(role));
        }
        if (!roleList.isEmpty()) {
            roleResourceModel.setRoles(roleList);
        }
        if (!resourceList.isEmpty()) {
            roleResourceModel.setPermissions(resourceList);
        }
        return roleResourceModel;
    }

    @Override
    public UserInfoResponse getUserInfo(String userId) {
        List<String> roleList;
        SysOrg sysOrg;
        UserInfoResponse userInfoResponse = new UserInfoResponse();
        SysUser sysUser = (SysUser)((Object)this.sysUserService.getById((Serializable)((Object)userId)));
        UserInfo userInfo = this.converterUI(sysUser);
        if (StringHelper.isNotBlank((CharSequence)userInfo.getOrgId()) && ObjectHelper.isNotEmpty((Object)((Object)(sysOrg = (SysOrg)((Object)this.sysOrgService.getById((Serializable)((Object)userInfo.getOrgId()))))))) {
            userInfo.setOrgName(sysOrg.getOrgName());
            userInfo.setParentIds(sysOrg.getParentIds());
        }
        if (!(roleList = this.sysUserRoleService.getRoles(userId)).isEmpty()) {
            List<UserRole> userRoles = this.sysRoleService.list((Wrapper)new QueryWrapper().in((Object)"role_id", roleList)).stream().map(this::converterURO).collect(Collectors.toList());
            Set resourceList = this.sysRoleResourceService.list((Wrapper)new QueryWrapper().in((Object)"role_id", roleList)).stream().map(SysRoleResource::getResourceId).collect(Collectors.toSet());
            List sysResourceList = this.sysResourceService.list((Wrapper)new QueryWrapper().in((Object)"resource_id", resourceList));
            List<UserResource> userResources = sysResourceList.stream().map(this::converterUR).collect(Collectors.toList());
            userInfo.setRoles(userRoles);
            userInfoResponse.setUserInfo(userInfo);
            userInfoResponse.setResources(userResources);
        }
        return userInfoResponse;
    }

    private UserRole converterURO(SysRole sysRole) {
        return UserRole.builder().roleId(sysRole.getRoleId()).roleName(sysRole.getRoleName()).build();
    }

    private UserResource converterUR(SysResource sysResource) {
        return UserResource.builder().resourceId(sysResource.getResourceId()).resourceName(sysResource.getResourceName()).resourceUrl(sysResource.getResourceUrl()).resourceSort(sysResource.getResourceSort()).resourceType(sysResource.getResourceType()).routerMapping(sysResource.getRouterMapping()).photoUrl(sysResource.getPhotoUrl()).permission(sysResource.getPermission()).isShow(sysResource.getIsShow()).parentId(sysResource.getParentId()).build();
    }

    private UserInfo converterUI(SysUser sysUser) {
        return UserInfo.builder().userId(sysUser.getUserId()).userType(sysUser.getUserType()).userName(sysUser.getUserName()).photoUrl(sysUser.getPhotoUrl()).loginName(sysUser.getLoginName()).orgId(sysUser.getOrgId()).build();
    }
}

