package com.testor.ddd.safetyControl.domain.space.service.impl;

import cn.hutool.core.util.StrUtil;
import com.testor.ddd.safetyControl.domain.space.entity.TSafeSpaceTypeRepo;
import com.testor.ddd.safetyControl.domain.space.service.SpaceTypeService;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceTypeDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceTypeDTOParam;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.constants.enumeration.BaseStatusEnum;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

@Service
public class SpaceTypeServiceImpl implements SpaceTypeService {

    @Resource
    private TSafeSpaceTypeRepo spaceTypeRepo;

    /**
     * 检测 名称、编码 是否都唯一
     * @param id
     * @param orgId
     * @param name
     * @param code
     * @return true - 唯一； false - 不唯一
     */
    public boolean checkUniqueness(String id, String orgId, String name, String code){
        List<TSafeSpaceTypeDTO> spaceTypeDTOList = spaceTypeRepo.checkUniqueness(id, orgId, name, code);
        if(spaceTypeDTOList == null || spaceTypeDTOList.size() == 0) {
            return true;
        }
        return false;
    }

    /**
     * 编辑空间
     *
     * @param spaceTypeDto
     * @return
     */
    @Transactional
    public BaseResponse editSpaceType(String userId, String orgId, TSafeSpaceTypeDTO spaceTypeDto) {
        BaseResponse baseResponse = new BaseResponse<>();

        boolean checkResult = checkUniqueness(spaceTypeDto.getId(), orgId, spaceTypeDto.getName(), spaceTypeDto.getCode());
        if (!checkResult) {
            baseResponse.setCode(BaseStatusEnum.UNKNOWN.code());
            baseResponse.setMsg("已存在相同名称/编码的数据");
            return baseResponse;
        }

        String dataId = spaceTypeDto.getId();
        if (StrUtil.isBlank(dataId)) { // 新增
            spaceTypeDto.setCreateBy(userId);
            spaceTypeDto.setOrgId(orgId);
            spaceTypeRepo.insert(spaceTypeDto);
            return baseResponse;
        }

        if (!orgId.equals(spaceTypeDto.getOrgId())) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("当前用户无法操作该条数据");
            return baseResponse;
        }

        spaceTypeDto.setUpdateBy(userId);
        spaceTypeRepo.updateById(spaceTypeDto);
        return baseResponse;
    }

    public BaseResponseList<TSafeSpaceTypeDTO> listByPage(TSafeSpaceTypeDTOParam param){

        BaseResponseList<TSafeSpaceTypeDTO> baseResponseList=new BaseResponseList<>();
        baseResponseList = spaceTypeRepo.listPage(param);
        return baseResponseList;
    }

    public TSafeSpaceTypeDTO findById(String id){
        return spaceTypeRepo.findById(id);
    }

    @Override
    public List<TSafeSpaceTypeDTO> myList() {
        return spaceTypeRepo.myList();
    }
}
