package com.testor.module.contractor.manage.model.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;

import java.math.BigDecimal;


/**
 * 承包商考核评价指标模板对象 t_contractor_evaluate_index
 * 
 * @author testor-framework
 * @date 2024-11-30 21:04:04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_evaluate_index")
@ApiModel(value = "TContractorEvaluateIndex对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorEvaluateIndex extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 维度指标项编号
 */
  @ApiModelProperty(value = "维度指标项编号")

  @TableId("index_code")
  private String indexCode;
/**
 * 维度
 */
  @ApiModelProperty(value = "维度")

  @TableField("dimension")
  private String dimension;
/**
 * 一级指标
 */
  @ApiModelProperty(value = "一级指标")

  @TableField("first_level")
  private String firstLevel;
/**
 * 二级指标
 */
  @ApiModelProperty(value = "二级指标")

  @TableField("second_level")
  private String secondLevel;
/**
 * 评价条款
 */
  @ApiModelProperty(value = "评价条款")

  @TableField("evaluation_terms")
  private String evaluationTerms;
/**
 * 基本分值
 */
  @ApiModelProperty(value = "基本分值" , example = "0")

  @TableField("basic_score")
  private Double basicScore;
/**
 * 计分标准
 */
  @ApiModelProperty(value = "计分标准")

  @TableField("score_standard")
  private String scoreStandard;
/**
 * 单次扣分
 */
  @ApiModelProperty(value = "单次扣分" , example = "0")

  @TableField("score_deduct")
  private Double scoreDeduct;

  /**
   * 适用性，0 否 1 是
   */
  @ApiModelProperty(value = "适用性，0 否 1 是")

  @TableField(exist = false)
  private String isUse;
  /**
   * 扣分说明
   */
  @ApiModelProperty(value = "扣分说明")

  @TableField(exist = false)
  private String deductDesc;
  /**
   * 得分
   */
  @ApiModelProperty(value = "得分", example = "0")

  @TableField(exist = false)
  private BigDecimal score;

  public static final String INDEX_CODE ="index_code";
  public static final String DIMENSION ="dimension";
  public static final String FIRST_LEVEL ="first_level";
  public static final String SECOND_LEVEL ="second_level";
  public static final String EVALUATION_TERMS ="evaluation_terms";
  public static final String BASIC_SCORE ="basic_score";
  public static final String SCORE_STANDARD ="score_standard";
  public static final String SCORE_DEDUCT ="score_deduct";

  @JsonIgnore
  public String getId(){
  	return this.indexCode;
  }
  @JsonIgnore
  public void setId(String indexCode){
  	this.indexCode = indexCode;
  }

}
