package com.testor.module.emergency.dao;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.emergency.model.domain.TEmergencyWorkingUser;
import com.testor.module.emergency.model.dto.TEmergencyWorkingUserParam;
import com.testor.module.emergency.model.vo.TEmergencyWorkingUserVO;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Param;

/**
 * 应急救援小组人员Mapper接口
 *
 * @author testor-framework
 * @date 2022-11-17 11:52:10
 */
public interface TEmergencyWorkingUserDao extends SuperDao<TEmergencyWorkingUser> {

    /**
     * 获取用户列表
     *
     * @param tEmergencyWorkingUserVOPage 用户vopage t应急工作
     * @param tEmergencyWorkingUserParam  用户参数t应急工作
     * @return {@link IPage}
     */
    Page<TEmergencyWorkingUserVO> getUserList(Page<TEmergencyWorkingUserVO> tEmergencyWorkingUserVOPage, @Param("param") TEmergencyWorkingUserParam tEmergencyWorkingUserParam);
}
