package com.testor.module.fives.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.fives.model.domain.TFivesToolFocus;
import com.testor.module.fives.model.dto.TFivesToolFocusDelParam;
import com.testor.module.fives.model.dto.TFivesToolFocusParam;
import com.testor.module.fives.service.TFivesToolFocusService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 5s工具运用焦点课题Controller
 *
 * @author testor-framework
 * @date 2022-07-21 15:56:54
 */
@RestController
@RequestMapping("/module/fives/tool/focus")
@Api(value = "TFivesToolFocus", tags = "5s工具运用焦点课题")
@Slf4j
public class TFivesToolFocusController extends SuperController {
    @Autowired
    private TFivesToolFocusService tFivesToolFocusService;

    /* Generated Method*/
    @ApiOperation(value = "新增 5s工具运用焦点课题", notes = "Add TFivesToolFocus")
    @PostMapping(value = "/add")
    public BaseResponse<TFivesToolFocus> addEntity(@RequestBody TFivesToolFocus addRequest) {
        BaseResponse<TFivesToolFocus> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(addRequest)) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            String id = IdHelper.getId32bit();
            TFivesToolFocus data = BeanHelper.beanToBean(addRequest, TFivesToolFocus.class);
            data.setId(id);
            boolean result = tFivesToolFocusService.save(data);
            if (result) {
                TFivesToolFocus newEntity = new TFivesToolFocus();
                newEntity.setId(id);
                baseResponse.setData(newEntity);
            }
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取 5s工具运用焦点课题 ", notes = "Get TFivesToolFocus By Id")
    @GetMapping(value = "/get")
    public BaseResponse<TFivesToolFocus> getById(String id) {
        BaseResponse<TFivesToolFocus> baseResponse = new BaseResponse<>();
        if (StringHelper.isNotEmpty(id)) {
            // TODO 按需求添加业务异常判断
            TFivesToolFocus data = tFivesToolFocusService.getById(id);
            baseResponse.setData(data);
        }
        return baseResponse;
    }

    @ApiOperation(value = "修改 5s工具运用焦点课题 ", notes = "Update TFivesToolFocus By Id")
    @PutMapping(value = "/update")
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TFivesToolFocus updateRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(updateRequest) && StringHelper.isNotEmpty(updateRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TFivesToolFocus data = BeanHelper.beanToBean(updateRequest, TFivesToolFocus.class);
            boolean result = tFivesToolFocusService.updateById(data);
            baseResponse.setData(BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "删除 5s工具运用焦点课题 ", notes = "delete TFivesToolFocus By Id")
    @PutMapping(value = "/delete")
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TFivesToolFocusDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && StringHelper.isNotEmpty(deleteRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TFivesToolFocus data = new TFivesToolFocus();
            data.setId(deleteRequest.getId());
            data.setStatus(BizConstants.STATUS_DELETE);
            boolean result = tFivesToolFocusService.updateById(data);
            baseResponse.setData(BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "批量删除5s工具运用焦点课题", notes = "delete TFivesToolFocus by batch Id")
    @PutMapping(value = "/batch_delete")
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(@RequestBody TFivesToolFocusDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
            List<TFivesToolFocus> tFivesToolFocusList = new ArrayList<>();
            for (String id : deleteRequest.getIds()) {
                TFivesToolFocus data = new TFivesToolFocus();
                data.setId(id);
                data.setStatus(BizConstants.STATUS_DELETE);
                tFivesToolFocusList.add(data);
            }
            boolean result = tFivesToolFocusService.updateBatchById(tFivesToolFocusList);
            baseResponse.setData(BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取 5s工具运用焦点课题 分页列表", notes = "List TFivesToolFocus with page")
    @GetMapping(value = "/list")
    public BaseResponse<BaseResponseList<TFivesToolFocus>> listEntity(TFivesToolFocusParam param) {
        BaseResponse<BaseResponseList<TFivesToolFocus>> baseResponse = new BaseResponse<>();
        Long page = StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TFivesToolFocus> resultPage = new Page<>(page, limit);
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TFivesToolFocus> queryWrapper = this.createQuery(param);
        Page<TFivesToolFocus> resultList = tFivesToolFocusService.page(resultPage, queryWrapper);
        BaseResponseList<TFivesToolFocus> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value = "获取 5s工具运用焦点课题 列表", notes = "List TFivesToolFocus all")
    @GetMapping(value = "/datas")
    public BaseResponse<BaseResponseList<TFivesToolFocus>> listAllEntity(TFivesToolFocusParam param) {
        BaseResponse<BaseResponseList<TFivesToolFocus>> baseResponse = new BaseResponse<>();
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TFivesToolFocus> queryWrapper = this.createQuery(param);
        List<TFivesToolFocus> resultList = tFivesToolFocusService.list(queryWrapper);
        BaseResponseList<TFivesToolFocus> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal(resultList.size());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    /* Private Methods */

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TFivesToolFocus> createQuery(TFivesToolFocusParam queryParam) {
        QueryWrapper<TFivesToolFocus> queryWrapper = new QueryWrapper<>();
        if (StringHelper.isNotEmpty(queryParam.getRefId())) {
            queryWrapper.eq(TFivesToolFocus.REF_ID, queryParam.getRefId());
        }
        if (StringHelper.isNotEmpty(queryParam.getParentId())) {
            queryWrapper.eq(TFivesToolFocus.PARENT_ID, queryParam.getParentId());
        }
        if (StringHelper.isNotEmpty(queryParam.getTenantId())) {
            queryWrapper.eq(TFivesToolFocus.TENANT_ID, queryParam.getTenantId());
        }
        if (StringHelper.isNotEmpty(queryParam.getProcessId())) {
            queryWrapper.eq(TFivesToolFocus.PROCESS_ID, queryParam.getProcessId());
        }
        if (StringHelper.isNotEmpty(queryParam.getProcessStatus())) {
            queryWrapper.eq(TFivesToolFocus.PROCESS_STATUS, queryParam.getProcessStatus());
        }
        if (StringHelper.isNotEmpty(queryParam.getCourseName())) {
            queryWrapper.like(TFivesToolFocus.COURSE_NAME, queryParam.getCourseName());
        }
        if (StringHelper.isNotEmpty(queryParam.getCourseSection())) {
            queryWrapper.eq(TFivesToolFocus.COURSE_SECTION, queryParam.getCourseSection());
        }
        if (StringHelper.isNotEmpty(queryParam.getCoursePrincipal())) {
            queryWrapper.eq(TFivesToolFocus.COURSE_PRINCIPAL, queryParam.getCoursePrincipal());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getTeamSize())) {
            queryWrapper.eq(TFivesToolFocus.TEAM_SIZE, queryParam.getTeamSize());
        }
        if (StringHelper.isNotEmpty(queryParam.getCourseDirection())) {
            queryWrapper.eq(TFivesToolFocus.COURSE_DIRECTION, queryParam.getCourseDirection());
        }
        if (StringHelper.isNotEmpty(queryParam.getFocusObj())) {
            queryWrapper.eq(TFivesToolFocus.FOCUS_OBJ, queryParam.getFocusObj());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getBeginDate())) {
            queryWrapper.eq(TFivesToolFocus.BEGIN_DATE, queryParam.getBeginDate());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getEndDate())) {
            queryWrapper.eq(TFivesToolFocus.END_DATE, queryParam.getEndDate());
        }
        if (StringHelper.isNotEmpty(queryParam.getBoostReason())) {
            queryWrapper.eq(TFivesToolFocus.BOOST_REASON, queryParam.getBoostReason());
        }
        if (StringHelper.isNotEmpty(queryParam.getBoostContent())) {
            queryWrapper.eq(TFivesToolFocus.BOOST_CONTENT, queryParam.getBoostContent());
        }
        if (StringHelper.isNotEmpty(queryParam.getExpectTarget())) {
            queryWrapper.eq(TFivesToolFocus.EXPECT_TARGET, queryParam.getExpectTarget());
        }
        if (StringHelper.isNotEmpty(queryParam.getLastResult())) {
            queryWrapper.eq(TFivesToolFocus.LAST_RESULT, queryParam.getLastResult());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TFivesToolFocus.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TFivesToolFocus.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty(queryParam.getOrderType()) && BizConstants.ASC.equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc(TFivesToolFocus.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
