package com.testor.module.fives.model.dto;

import com.testor.module.fives.model.domain.TFivesToolUse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 5s工具运用 删除参数对象
 *
 * @author testor-framework
 * @date 2022-07-21 15:56:55
 */

@Data
@ApiModel(value = "TFivesToolUse 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TFivesToolUseParam extends TFivesToolUse {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "每页数量")
    private String limit;

    @ApiModelProperty(value = "当前页数")
    private String page;

    @ApiModelProperty(value = "排序字段")
    private String orderBy;

    @ApiModelProperty(value = "排序方式")
    private String orderType;

    @ApiModelProperty(value = "主题名称")
    private String themeName;

    @ApiModelProperty(value = "开始时间")
    /*@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")*/
    private String startDate;

    @ApiModelProperty(value = "结束时间")
    /*@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")*/
    private String endDate;

    @ApiModelProperty(value = "用于后端控制权限")
    private List<String> companyIds;

    @ApiModelProperty("获取亮点数据列表前端传 1")
    private String brightPost;

    @ApiModelProperty("工具运用列表必传")
    private String toolList;

}
