package com.testor.module.hazard.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.testor.module.hazard.model.domain.THazardDisclosureDetails;
import com.testor.module.hazard.model.dto.THazardDisclosureDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.hazard.model.domain.THazardDisclosure;
import com.testor.module.hazard.model.dto.THazardDisclosureParam;
import com.testor.module.hazard.model.dto.THazardDisclosureDelParam;
import com.testor.module.hazard.service.THazardDisclosureService;

/**
 * 危险作业-交底信息Controller
 *
 * @author testor-framework
 * @date 2024-12-28 19:52:55
 */
@RestController
@RequestMapping("/hazard/disclosure")
@Api(value = "THazardDisclosure", tags = "危险作业-交底信息")
@Slf4j
public class THazardDisclosureController extends SuperController
{
    @Autowired
    private THazardDisclosureService tHazardDisclosureService;

    /* Generated Method*/
	@ApiOperation(value = "新增 危险作业-交底信息", notes = "Add THazardDisclosure")
	@PostMapping(value = "/saveOrUpdate")
	public BaseResponse<THazardDisclosure>saveOrUpdateEntity(@RequestBody THazardDisclosureDTO addRequest) {
		BaseResponse<THazardDisclosure> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			THazardDisclosure result= tHazardDisclosureService.saveOrUpdateEntity(addRequest);
			baseResponse.setData(result);
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业-交底信息 ", notes = "Get THazardDisclosure By Id")
	@GetMapping(value = "/get")
	public BaseResponse<THazardDisclosure> getById(String planId,String workTypeId,String batch){
		BaseResponse<THazardDisclosure> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(planId)){
			// TODO 按需求添加业务异常判断
            THazardDisclosureDTO data= tHazardDisclosureService.getDetailsById(planId,workTypeId,batch);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 危险作业-交底信息 ", notes = "Update THazardDisclosure By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody THazardDisclosure updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardDisclosure data=BeanHelper.beanToBean(updateRequest, THazardDisclosure.class);
			boolean result= tHazardDisclosureService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 危险作业-交底信息 ", notes = "delete THazardDisclosure By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody THazardDisclosureDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardDisclosure data= new THazardDisclosure();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tHazardDisclosureService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除危险作业-交底信息", notes = "delete THazardDisclosure by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody THazardDisclosureDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<THazardDisclosure> tHazardDisclosureList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                THazardDisclosure data= new THazardDisclosure();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tHazardDisclosureList.add(data);
			}
			boolean result = tHazardDisclosureService.updateBatchById(tHazardDisclosureList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业-交底信息 分页列表", notes = "List THazardDisclosure with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<THazardDisclosure>>listEntity(THazardDisclosureParam param){
		BaseResponse<BaseResponseList<THazardDisclosure>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<THazardDisclosure> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<THazardDisclosure> queryWrapper=this.createQuery(param);
		Page<THazardDisclosure> resultList= tHazardDisclosureService.page(resultPage,queryWrapper);
		BaseResponseList<THazardDisclosure> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业-交底信息 列表", notes = "List THazardDisclosure all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<THazardDisclosure>>listAllEntity(THazardDisclosureParam param){
		BaseResponse<BaseResponseList<THazardDisclosure>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<THazardDisclosure> queryWrapper=this.createQuery(param);
		List<THazardDisclosure> resultList=tHazardDisclosureService.list(queryWrapper);
		BaseResponseList<THazardDisclosure> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<THazardDisclosure> createQuery(THazardDisclosureParam queryParam){
		QueryWrapper<THazardDisclosure> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getPlanId())){
			queryWrapper.eq(THazardDisclosure.PLAN_ID,queryParam.getPlanId());
		}
		if(StringHelper.isNotEmpty(queryParam.getOnSiteMeasures())){
			queryWrapper.eq(THazardDisclosure.ON_SITE_MEASURES,queryParam.getOnSiteMeasures());
		}
		if(StringHelper.isNotEmpty(queryParam.getOnSiteMeasuresFile())){
			queryWrapper.eq(THazardDisclosure.ON_SITE_MEASURES_FILE,queryParam.getOnSiteMeasuresFile());
		}
		if(StringHelper.isNotEmpty(queryParam.getSafetyPrecautions())){
			queryWrapper.eq(THazardDisclosure.SAFETY_PRECAUTIONS,queryParam.getSafetyPrecautions());
		}
		if(StringHelper.isNotEmpty(queryParam.getSafetyPrecautionsFile())){
			queryWrapper.eq(THazardDisclosure.SAFETY_PRECAUTIONS_FILE,queryParam.getSafetyPrecautionsFile());
		}
		if(StringHelper.isNotEmpty(queryParam.getContactPerson())){
			queryWrapper.eq(THazardDisclosure.CONTACT_PERSON,queryParam.getContactPerson());
		}
		if(StringHelper.isNotEmpty(queryParam.getContactPersonFile())){
			queryWrapper.eq(THazardDisclosure.CONTACT_PERSON_FILE,queryParam.getContactPersonFile());
		}
		if(StringHelper.isNotEmpty(queryParam.getEmergencySupplies())){
			queryWrapper.eq(THazardDisclosure.EMERGENCY_SUPPLIES,queryParam.getEmergencySupplies());
		}
		if(StringHelper.isNotEmpty(queryParam.getEmergencySuppliesFile())){
			queryWrapper.eq(THazardDisclosure.EMERGENCY_SUPPLIES_FILE,queryParam.getEmergencySuppliesFile());
		}
		if(StringHelper.isNotEmpty(queryParam.getDisclosurePersonSign())){
			queryWrapper.eq(THazardDisclosure.DISCLOSURE_PERSON_SIGN,queryParam.getDisclosurePersonSign());
		}
		if(StringHelper.isNotEmpty(queryParam.getRecipientSignature())){
			queryWrapper.eq(THazardDisclosure.RECIPIENT_SIGNATURE,queryParam.getRecipientSignature());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getBatch())){
			queryWrapper.eq(THazardDisclosure.BATH,queryParam.getBatch());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(THazardDisclosure.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(THazardDisclosure.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(THazardDisclosure.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
