package com.testor.module.hazard.model.template;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

@Data
public class HazardWorkPlanStatisticsTemplate {
    @ExcelProperty("序号")
    private String number;

    @ExcelProperty("大区")
    private String regionName;

    @ExcelProperty("经营部")
    private String businessDeptName;

    @ExcelProperty("企业名称")
    private String currentOrgName;

    @ExcelProperty("危险作业总量")
    private Integer workCount;

    @ExcelProperty("自有员工作业数量")
    private Integer ownCount;

    @ExcelProperty("相关方作业数量")
    private Integer stakeholderCount;

    // ============== 作业类别统计 ==============

    @ExcelProperty("进仓作业")
    private Integer workTypeIn;

    @ExcelProperty("出仓作业")
    private Integer workTypeOut;

    @ExcelProperty("动火作业")
    private Integer workTypeFire;

    @ExcelProperty("有限空间作业")
    private Integer workTypeLimitedSpace;

    @ExcelProperty("吊装作业")
    private Integer workTypeHoisting;

    @ExcelProperty("高处作业")
    private Integer workTypeHigh;

    @ExcelProperty("临时用电作业")
    private Integer workTypeTempElectricity;

    @ExcelProperty("动土作业")
    private Integer workTypeExcavation;

    @ExcelProperty("断路作业")
    private Integer workTypeRoadClosure;

    @ExcelProperty("环流熏蒸作业")
    private Integer workTypeCirculationFumigation;

    @ExcelProperty("熏蒸作业")
    private Integer workTypeFumigation;

    @ExcelProperty("平仓作业")
    private Integer workTypeClosing;

    @ExcelProperty("筒仓清仓作业")
    private Integer workTypeSiloCleaning;

    @ExcelProperty("液氨接卸作业")
    private Integer workTypeLiquidAmmonia;

    @ExcelProperty("未知类别")
    private Integer workTypeUnknown;

    // ============== 作业级别统计 ==============

    @ExcelProperty("高度危险")
    private Integer workLevelHigh;

    @ExcelProperty("较大危险")
    private Integer workLevelMedium;

    @ExcelProperty("一般危险")
    private Integer workLevelLow;

    @ExcelProperty("未知级别")
    private Integer workLevelUnknown;

    // ============== 作业状态统计 ==============

    @ExcelProperty("技术交底")
    private Integer workStatusTechBriefing;

    @ExcelProperty("草稿")
    private Integer workStatusDraft;

    @ExcelProperty("已关闭")
    private Integer workStatusClosed;

    @ExcelProperty("作业前（条件确认）")
    private Integer workStatusPreCondition;

    @ExcelProperty("作业前（风险分析）")
    private Integer workStatusPreRiskAnalysis;

    @ExcelProperty("已超时自动取消")
    private Integer workStatusTimeoutCancel;

    @ExcelProperty("已取消")
    private Integer workStatusCancelled;

    @ExcelProperty("作业前（许可证）")
    private Integer workStatusPreLicense;

    @ExcelProperty("未知状态")
    private Integer workStatusUnknown;

}
